/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.relay.ConfigurableRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.relay.FailingNostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthRepository;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicyType;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

class AllRelaysDownTest {
    @TempDir
    Path tempDir;

    AllRelaysDownTest() {
    }

    private IdentityKeyService identityKeyService() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = generator.generateKeyPair();
        final IdentityKey id = new IdentityKey(keyPair.getPrivate(), keyPair.getPublic());
        return new IdentityKeyService(this){

            public synchronized IdentityKey loadOrCreate() {
                return id;
            }
        };
    }

    private WalletKeyManager walletKeyManager() {
        final WalletSigningKey signingKey = new WalletSigningKey(new byte[]{1}, new byte[]{2}, new byte[]{3}, 1);
        return new WalletKeyManager(this, new SecureKeyStore(this){

            public Optional<byte[]> load(String alias) {
                return Optional.empty();
            }

            public void store(String alias, byte[] value) {
            }
        }){

            public synchronized WalletSigningKey loadOrCreate(IdentityKey ignored) {
                return signingKey;
            }
        };
    }

    @Test
    void startFailsWhenNoRelaysAreReachable() throws Exception {
        List<NostrRelayOption> relays = List.of(new NostrRelayOption("wss://relay1.down.example", false), new NostrRelayOption("wss://relay2.down.example", false), new NostrRelayOption("wss://relay3.down.example", false));
        ConfigurableRelayClientFactory clientFactory = new ConfigurableRelayClientFactory();
        clientFactory.setDefaultFailureMode(FailingNostrRelayClient.FailureMode.ALWAYS);
        RelayHealthMonitor healthMonitor = new RelayHealthMonitor();
        RelayReEvaluator reEvaluator = new RelayReEvaluator(Duration.ofMillis(50L), 3);
        RelayHealthRepository repository = new RelayHealthRepository(this.tempDir.resolve("relay-health-test.properties"));
        NostrGatewayService gateway = new NostrGatewayService(() -> new NostrGatewayConfig(relays), this.identityKeyService(), this.walletKeyManager(), (NostrRelayClientFactory)clientFactory, RelaySelectionPolicyType.RANDOM.createPolicy(), healthMonitor, reEvaluator, repository, false);
        IllegalStateException ex = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((NostrGatewayService)gateway).start());
        Assertions.assertTrue((boolean)ex.getMessage().contains("no_relays_available"));
        Map summary = healthMonitor.getHealthSummary();
        Assertions.assertEquals((int)3, (int)summary.size());
        summary.forEach((url, score) -> Assertions.assertTrue((score < 70.0 ? 1 : 0) != 0));
    }
}

