/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.RelayUnavailableException;
import xyz.tcheeric.wallet.core.nostr.relay.ConfigurableRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.relay.FailingNostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthRepository;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicyType;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

class CircuitBreakerBehaviorTest {
    @TempDir
    Path tempDir;
    private NostrGatewayService gateway;

    CircuitBreakerBehaviorTest() {
    }

    private IdentityKeyService identityKeyService() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = generator.generateKeyPair();
        final IdentityKey id = new IdentityKey(keyPair.getPrivate(), keyPair.getPublic());
        return new IdentityKeyService(this){

            public synchronized IdentityKey loadOrCreate() {
                return id;
            }
        };
    }

    private WalletKeyManager walletKeyManager() {
        final WalletSigningKey signingKey = new WalletSigningKey(new byte[]{1}, new byte[]{2}, new byte[]{3}, 1);
        return new WalletKeyManager(this, new SecureKeyStore(this){

            public Optional<byte[]> load(String alias) {
                return Optional.empty();
            }

            public void store(String alias, byte[] value) {
            }
        }){

            public synchronized WalletSigningKey loadOrCreate(IdentityKey ignored) {
                return signingKey;
            }
        };
    }

    @BeforeEach
    void setUp() throws Exception {
        ConfigurableRelayClientFactory clientFactory = new ConfigurableRelayClientFactory();
        clientFactory.setFailureMode("wss://good.example", FailingNostrRelayClient.FailureMode.NEVER);
        clientFactory.setFailureMode("wss://flaky.example", FailingNostrRelayClient.FailureMode.INTERMITTENT);
        RelayHealthMonitor healthMonitor = new RelayHealthMonitor();
        RelayReEvaluator reEvaluator = new RelayReEvaluator(Duration.ofMillis(50L), 5);
        List<NostrRelayOption> relays = List.of(new NostrRelayOption("wss://good.example", false), new NostrRelayOption("wss://flaky.example", false));
        System.setProperty("wallet.relay.circuitBreaker.failureRateThreshold", "25");
        System.setProperty("wallet.relay.circuitBreaker.windowType", "COUNT");
        System.setProperty("wallet.relay.circuitBreaker.windowSize", "4");
        System.setProperty("wallet.relay.circuitBreaker.minimumCalls", "2");
        System.setProperty("wallet.relay.circuitBreaker.openWaitMs", "200");
        System.setProperty("wallet.relay.circuitBreaker.permittedHalfOpen", "1");
        this.gateway = new NostrGatewayService(() -> new NostrGatewayConfig(relays), this.identityKeyService(), this.walletKeyManager(), (NostrRelayClientFactory)clientFactory, RelaySelectionPolicyType.RANDOM.createPolicy(), healthMonitor, reEvaluator, new RelayHealthRepository(this.tempDir.resolve("relay-health-test.properties")), false);
        this.gateway.start();
    }

    @AfterEach
    void tearDown() {
        if (this.gateway != null) {
            this.gateway.close();
        }
        System.clearProperty("wallet.relay.circuitBreaker.failureRateThreshold");
        System.clearProperty("wallet.relay.circuitBreaker.windowType");
        System.clearProperty("wallet.relay.circuitBreaker.windowSize");
        System.clearProperty("wallet.relay.circuitBreaker.minimumCalls");
        System.clearProperty("wallet.relay.circuitBreaker.openWaitMs");
        System.clearProperty("wallet.relay.circuitBreaker.permittedHalfOpen");
    }

    @Test
    void breakerOpensAndHalfOpenAllowsTrialCall() {
        NostrEvent event = new NostrEvent("id", "pub", 1, "content", Instant.now(), List.of(), null);
        for (int i = 0; i < 3; ++i) {
            try {
                this.gateway.publish(event, List.of("wss://flaky.example"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assertions.assertThrows(RelayUnavailableException.class, () -> this.gateway.publish(event, List.of("wss://flaky.example")));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.gateway.publish(event, List.of("wss://flaky.example"));
        }
        catch (CallNotPermittedException e) {
            Assertions.fail((String)"Call should be permitted in HALF_OPEN state");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

