/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.relay.FailingNostrRelayClient;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class ConfigurableRelayClientFactory
implements NostrRelayClientFactory {
    private final Map<String, FailingNostrRelayClient.FailureMode> failureModes = new ConcurrentHashMap<String, FailingNostrRelayClient.FailureMode>();
    private final Map<String, FailingNostrRelayClient> createdClients = new ConcurrentHashMap<String, FailingNostrRelayClient>();
    private FailingNostrRelayClient.FailureMode defaultMode = FailingNostrRelayClient.FailureMode.NEVER;

    public void setFailureMode(String url, FailingNostrRelayClient.FailureMode failureMode) {
        this.failureModes.put(url, failureMode);
    }

    public void setDefaultFailureMode(FailingNostrRelayClient.FailureMode failureMode) {
        this.defaultMode = failureMode;
    }

    public FailingNostrRelayClient getClient(String url) {
        return this.createdClients.get(url);
    }

    public NostrRelayClient create(NostrRelayOption option, IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        String url = option.url();
        FailingNostrRelayClient.FailureMode mode = this.failureModes.getOrDefault(url, this.defaultMode);
        FailingNostrRelayClient client = new FailingNostrRelayClient(url, mode);
        this.createdClients.put(url, client);
        return client;
    }
}

