/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class FailingNostrRelayClient
implements NostrRelayClient {
    private final String url;
    private final FailureMode failureMode;
    private final AtomicInteger operationCount = new AtomicInteger(0);
    private boolean connected = false;
    private boolean authEnabled = false;

    public FailingNostrRelayClient(String url, FailureMode failureMode) {
        this.url = url;
        this.failureMode = failureMode;
    }

    public void connect() {
        if (this.shouldFail()) {
            throw new RuntimeException("Simulated connection failure");
        }
        this.connected = true;
    }

    public void publish(NostrEvent event) {
        if (this.failureMode == FailureMode.SLOW) {
            this.simulateLatency(500);
        }
        if (this.shouldFail()) {
            throw new RuntimeException("Simulated publish failure");
        }
        this.operationCount.incrementAndGet();
    }

    public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        if (this.shouldFail()) {
            throw new RuntimeException("Simulated subscribe failure");
        }
        this.operationCount.incrementAndGet();
        return () -> {};
    }

    public void enableAuth(IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        this.authEnabled = true;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String url() {
        return this.url;
    }

    public void close() {
        this.connected = false;
    }

    public int getOperationCount() {
        return this.operationCount.get();
    }

    public boolean isConnected() {
        return this.connected;
    }

    private boolean shouldFail() {
        return switch (this.failureMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2 -> {
                if (this.operationCount.incrementAndGet() % 2 == 0) {
                    yield true;
                }
                yield false;
            }
            case 0, 3 -> false;
        };
    }

    private void simulateLatency(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static enum FailureMode {
        NEVER,
        ALWAYS,
        INTERMITTENT,
        SLOW;

    }
}

