/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.relay.ConfigurableRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.relay.FailingNostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthRepository;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicyType;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

class PartialRelayFailureTest {
    @TempDir
    Path tempDir;
    private NostrGatewayService gateway;
    private RelayHealthMonitor healthMonitor;
    private ConfigurableRelayClientFactory clientFactory;

    PartialRelayFailureTest() {
    }

    private IdentityKeyService identityKeyService() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = generator.generateKeyPair();
        final IdentityKey id = new IdentityKey(keyPair.getPrivate(), keyPair.getPublic());
        return new IdentityKeyService(this){

            public synchronized IdentityKey loadOrCreate() {
                return id;
            }
        };
    }

    private WalletKeyManager walletKeyManager() {
        final WalletSigningKey signingKey = new WalletSigningKey(new byte[]{1}, new byte[]{2}, new byte[]{3}, 1);
        return new WalletKeyManager(this, new SecureKeyStore(this){

            public Optional<byte[]> load(String alias) {
                return Optional.empty();
            }

            public void store(String alias, byte[] value) {
            }
        }){

            public synchronized WalletSigningKey loadOrCreate(IdentityKey ignored) {
                return signingKey;
            }
        };
    }

    @BeforeEach
    void setUp() throws Exception {
        this.clientFactory = new ConfigurableRelayClientFactory();
        this.healthMonitor = new RelayHealthMonitor();
        RelayReEvaluator reEvaluator = new RelayReEvaluator(Duration.ofMillis(50L), 5);
        List<NostrRelayOption> relays = List.of(new NostrRelayOption("wss://healthy-1.example", false), new NostrRelayOption("wss://healthy-2.example", false), new NostrRelayOption("wss://failing-1.example", false), new NostrRelayOption("wss://failing-2.example", false));
        this.clientFactory.setFailureMode("wss://failing-1.example", FailingNostrRelayClient.FailureMode.ALWAYS);
        this.clientFactory.setFailureMode("wss://failing-2.example", FailingNostrRelayClient.FailureMode.ALWAYS);
        this.clientFactory.setFailureMode("wss://healthy-1.example", FailingNostrRelayClient.FailureMode.NEVER);
        this.clientFactory.setFailureMode("wss://healthy-2.example", FailingNostrRelayClient.FailureMode.NEVER);
        this.gateway = new NostrGatewayService(() -> new NostrGatewayConfig(relays), this.identityKeyService(), this.walletKeyManager(), (NostrRelayClientFactory)this.clientFactory, RelaySelectionPolicyType.RANDOM.createPolicy(), this.healthMonitor, reEvaluator, new RelayHealthRepository(this.tempDir.resolve("relay-health-test.properties")), false);
        this.gateway.start();
    }

    @AfterEach
    void tearDown() {
        if (this.gateway != null) {
            this.gateway.close();
        }
    }

    @Test
    void publishSucceedsViaHealthyRelaysAndScoresReflect() {
        NostrEvent event = new NostrEvent("id", "pub", 1, "content", Instant.now(), List.of(), null);
        Assertions.assertDoesNotThrow(() -> {
            for (int i = 0; i < 5; ++i) {
                this.gateway.publish(event);
            }
        });
        Double h1 = (Double)this.healthMonitor.getHealthSummary().get("wss://healthy-1.example");
        Double h2 = (Double)this.healthMonitor.getHealthSummary().get("wss://healthy-2.example");
        Double f1 = (Double)this.healthMonitor.getHealthSummary().get("wss://failing-1.example");
        Double f2 = (Double)this.healthMonitor.getHealthSummary().get("wss://failing-2.example");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertNotNull((Object)h2);
        Assertions.assertNotNull((Object)f1);
        Assertions.assertNotNull((Object)f2);
        Assertions.assertTrue((h1 > f1 ? 1 : 0) != 0);
        Assertions.assertTrue((h2 > f2 ? 1 : 0) != 0);
    }
}

