/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RandomRelayPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

class RandomRelayPolicyTest {
    private RandomRelayPolicy policy;

    RandomRelayPolicyTest() {
    }

    @BeforeEach
    void setUp() {
        this.policy = new RandomRelayPolicy(new Random(42L));
    }

    @Test
    void selectWithEmptyRelaysThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select(List.of(), 1, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectWithZeroCountThrowsException() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select((Collection)relays, 0, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectWithNegativeCountThrowsException() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select((Collection)relays, -1, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectSingleRelay() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://relay1.com", (Object)((RelayConnection)selected.get(0)).url());
    }

    @Test
    void selectPrefersHealthyRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.degraded((String)"wss://degraded.com"), RelayConnection.connected((String)"wss://healthy.com"));
        List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://healthy.com", (Object)((RelayConnection)selected.get(0)).url());
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)((RelayConnection)selected.get(0)).status());
    }

    @Test
    void selectRandomizesAcrossHealthyRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"), RelayConnection.connected((String)"wss://relay4.com"), RelayConnection.connected((String)"wss://relay5.com"));
        HashSet<String> selectedUrls = new HashSet<String>();
        for (int i = 0; i < 20; ++i) {
            List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
            selectedUrls.add(((RelayConnection)selected.get(0)).url());
        }
        Assertions.assertTrue((selectedUrls.size() > 1 ? 1 : 0) != 0, (String)"Random selection should distribute across multiple relays");
    }

    @Test
    void selectSkipsDisconnectedRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.disconnected((String)"wss://offline.com"), RelayConnection.connected((String)"wss://online.com"));
        List selected = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://online.com", (Object)((RelayConnection)selected.get(0)).url());
    }

    @Test
    void selectIncludesDegradedRelaysWhenNoHealthyAvailable() {
        List<RelayConnection> relays = List.of(RelayConnection.degraded((String)"wss://degraded1.com"), RelayConnection.degraded((String)"wss://degraded2.com"));
        List selected = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)2, (int)selected.size());
        Assertions.assertTrue((boolean)selected.stream().allMatch(r -> r.status() == RelayStatus.DEGRADED));
    }

    @Test
    void selectFillsFromDegradedWhenHealthyInsufficient() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://healthy.com"), RelayConnection.degraded((String)"wss://degraded1.com"), RelayConnection.degraded((String)"wss://degraded2.com"));
        List selected = this.policy.select(relays, 3, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)3, (int)selected.size());
        long healthyCount = selected.stream().filter(RelayConnection::isHealthy).count();
        long degradedCount = selected.stream().filter(r -> r.status() == RelayStatus.DEGRADED).count();
        Assertions.assertEquals((long)1L, (long)healthyCount);
        Assertions.assertEquals((long)2L, (long)degradedCount);
    }

    @Test
    void selectReturnsLessThanRequestedWhenInsufficientAvailable() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"));
        List selected = this.policy.select(relays, 5, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)2, (int)selected.size(), (String)"Should return only available relays");
    }

    @Test
    void selectReturnsUniqueRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        List selected = this.policy.select(relays, 3, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)3, (int)selected.size());
        HashSet urls = new HashSet();
        selected.forEach(r -> urls.add(r.url()));
        Assertions.assertEquals((int)3, (int)urls.size(), (String)"All selected relays should be unique");
    }

    @Test
    void selectWithDifferentContextsProducesSameDistribution() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        List publishSelection = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        List subscribeSelection = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forSubscribe());
        Assertions.assertEquals((int)2, (int)publishSelection.size());
        Assertions.assertEquals((int)2, (int)subscribeSelection.size());
    }

    @Test
    void selectProvidesUniformDistributionOverTime() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        int[] selectionCounts = new int[3];
        List<String> urls = List.of("wss://relay1.com", "wss://relay2.com", "wss://relay3.com");
        for (int i = 0; i < 300; ++i) {
            int index;
            List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
            String selectedUrl = ((RelayConnection)selected.get(0)).url();
            int n = index = urls.indexOf(selectedUrl);
            selectionCounts[n] = selectionCounts[n] + 1;
        }
        for (int count : selectionCounts) {
            Assertions.assertTrue((count > 70 && count < 130 ? 1 : 0) != 0, (String)("Selection distribution should be roughly uniform, got: " + count));
        }
    }

    @Test
    void selectWithSeededRandomIsReproducible() {
        Random seed1 = new Random(123L);
        Random seed2 = new Random(123L);
        RandomRelayPolicy policy1 = new RandomRelayPolicy(seed1);
        RandomRelayPolicy policy2 = new RandomRelayPolicy(seed2);
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        List selection1 = policy1.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        List selection2 = policy2.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((Object)((RelayConnection)selection1.get(0)).url(), (Object)((RelayConnection)selection2.get(0)).url());
        Assertions.assertEquals((Object)((RelayConnection)selection1.get(1)).url(), (Object)((RelayConnection)selection2.get(1)).url());
    }
}

