/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import xyz.tcheeric.wallet.core.nostr.relay.EvictedRelay;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthRepository;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthSnapshot;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;

class RelayHealthRepositoryTest {
    @TempDir
    Path tempDir;
    private RelayHealthRepository repository;
    private Path testFile;

    RelayHealthRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.testFile = this.tempDir.resolve("relay-health-test.properties");
        this.repository = new RelayHealthRepository(this.testFile);
    }

    @AfterEach
    void tearDown() {
        this.repository.clear();
    }

    @Test
    void saveAndLoadEmptyState() {
        this.repository.save(Map.of(), Map.of());
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertTrue((boolean)loaded.isEmpty());
    }

    @Test
    void saveAndLoadMetrics() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(250L), 95L, 100L, 9L, 10L, Instant.now());
        this.repository.save(Map.of("wss://relay.example", metrics), Map.of());
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)1, (int)loaded.metrics().size());
        RelayMetrics loadedMetrics = (RelayMetrics)loaded.metrics().get("wss://relay.example");
        Assertions.assertNotNull((Object)loadedMetrics);
        Assertions.assertEquals((long)95L, (long)loadedMetrics.successfulOperations());
        Assertions.assertEquals((long)100L, (long)loadedMetrics.totalOperations());
        Assertions.assertEquals((long)9L, (long)loadedMetrics.successfulConnections());
        Assertions.assertEquals((long)10L, (long)loadedMetrics.connectionAttempts());
        Assertions.assertEquals((Object)Duration.ofMillis(250L), (Object)loadedMetrics.p95Latency());
    }

    @Test
    void saveAndLoadEvictedRelays() {
        EvictedRelay evicted = new EvictedRelay("wss://evicted.example", Instant.now(), 25.0, 2);
        this.repository.save(Map.of(), Map.of("wss://evicted.example", evicted));
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)1, (int)loaded.evictedRelays().size());
        EvictedRelay loadedEvicted = (EvictedRelay)loaded.evictedRelays().get("wss://evicted.example");
        Assertions.assertNotNull((Object)loadedEvicted);
        Assertions.assertEquals((double)25.0, (double)loadedEvicted.evictionScore());
        Assertions.assertEquals((int)2, (int)loadedEvicted.retryCount());
    }

    @Test
    void saveAndLoadCompleteState() {
        RelayMetrics metrics1 = new RelayMetrics("wss://relay1.example", Duration.ofMillis(100L), 100L, 100L, 10L, 10L, Instant.now());
        RelayMetrics metrics2 = new RelayMetrics("wss://relay2.example", Duration.ofMillis(500L), 80L, 100L, 8L, 10L, Instant.now());
        EvictedRelay evicted = EvictedRelay.create((String)"wss://evicted.example", (double)20.0);
        Map<String, RelayMetrics> metricsMap = Map.of("wss://relay1.example", metrics1, "wss://relay2.example", metrics2);
        Map<String, EvictedRelay> evictedMap = Map.of("wss://evicted.example", evicted);
        this.repository.save(metricsMap, evictedMap);
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)2, (int)loaded.metrics().size());
        Assertions.assertEquals((int)1, (int)loaded.evictedRelays().size());
    }

    @Test
    void loadNonExistentFileReturnsEmptySnapshot() {
        Path nonExistent = this.tempDir.resolve("nonexistent.properties");
        RelayHealthRepository repo = new RelayHealthRepository(nonExistent);
        RelayHealthSnapshot loaded = repo.load();
        Assertions.assertTrue((boolean)loaded.isEmpty());
    }

    @Test
    void clearRemovesFile() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        this.repository.save(Map.of("wss://relay.example", metrics), Map.of());
        Assertions.assertTrue((boolean)this.testFile.toFile().exists());
        this.repository.clear();
        Assertions.assertFalse((boolean)this.testFile.toFile().exists());
    }

    @Test
    void multipleSavesOverwritePrevious() {
        RelayMetrics metrics1 = RelayMetrics.initial((String)"wss://relay1.example");
        this.repository.save(Map.of("wss://relay1.example", metrics1), Map.of());
        RelayMetrics metrics2 = RelayMetrics.initial((String)"wss://relay2.example");
        this.repository.save(Map.of("wss://relay2.example", metrics2), Map.of());
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)1, (int)loaded.metrics().size());
        Assertions.assertTrue((boolean)loaded.metrics().containsKey("wss://relay2.example"));
        Assertions.assertFalse((boolean)loaded.metrics().containsKey("wss://relay1.example"));
    }

    @Test
    void handlesMetricsWithoutLatency() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 50L, 100L, 5L, 10L, Instant.now());
        this.repository.save(Map.of("wss://relay.example", metrics), Map.of());
        RelayHealthSnapshot loaded = this.repository.load();
        RelayMetrics loadedMetrics = (RelayMetrics)loaded.metrics().get("wss://relay.example");
        Assertions.assertNotNull((Object)loadedMetrics);
        Assertions.assertNull((Object)loadedMetrics.p95Latency());
    }

    @Test
    void handlesSpecialCharactersInUrls() {
        String complexUrl = "wss://relay.example.com:443/path";
        RelayMetrics metrics = RelayMetrics.initial((String)complexUrl);
        EvictedRelay evicted = EvictedRelay.create((String)complexUrl, (double)10.0);
        this.repository.save(Map.of(complexUrl, metrics), Map.of(complexUrl, evicted));
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)1, (int)loaded.metrics().size());
        Assertions.assertTrue((boolean)loaded.metrics().containsKey(complexUrl));
        RelayMetrics loadedMetrics = (RelayMetrics)loaded.metrics().get(complexUrl);
        Assertions.assertNotNull((Object)loadedMetrics);
        Assertions.assertEquals((Object)complexUrl, (Object)loadedMetrics.relayUrl());
    }

    @Test
    void preservesEvictedRelayUrlsWithSpecialCharacters() {
        String complexUrl = "wss://relay.example.com:443/path";
        EvictedRelay evictedRelay = EvictedRelay.create((String)complexUrl, (double)12.5);
        this.repository.save(Map.of(), Map.of(complexUrl, evictedRelay));
        RelayHealthSnapshot loaded = this.repository.load();
        Assertions.assertEquals((int)1, (int)loaded.evictedRelays().size());
        Assertions.assertTrue((boolean)loaded.evictedRelays().containsKey(complexUrl));
        EvictedRelay loadedRelay = (EvictedRelay)loaded.evictedRelays().get(complexUrl);
        Assertions.assertNotNull((Object)loadedRelay);
        Assertions.assertEquals((Object)complexUrl, (Object)loadedRelay.relayUrl());
    }
}

