/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthScorer;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

class RelayHealthScorerTest {
    RelayHealthScorerTest() {
    }

    @Test
    void calculateScoreForPerfectRelay() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertEquals((double)100.0, (double)score, (double)0.1);
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)scorer.determineStatus());
    }

    @Test
    void calculateScoreForSlowRelay() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofSeconds(4L), 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertTrue((score < 70.0 ? 1 : 0) != 0, (String)"Slow relay should be below CONNECTED threshold");
        Assertions.assertTrue((score >= 30.0 ? 1 : 0) != 0, (String)"Slow relay should still be DEGRADED");
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)scorer.determineStatus());
    }

    @Test
    void calculateScoreForUnreliableRelay() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(200L), 50L, 100L, 5L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertTrue((score >= 30.0 ? 1 : 0) != 0, (String)"Unreliable relay should be at least DEGRADED");
        Assertions.assertTrue((score < 90.0 ? 1 : 0) != 0, (String)"Unreliable relay should not be near perfect");
    }

    @Test
    void calculateScoreForFailingRelay() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofSeconds(6L), 10L, 100L, 1L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertTrue((score < 30.0 ? 1 : 0) != 0, (String)"Failing relay should be DISCONNECTED");
        Assertions.assertEquals((Object)RelayStatus.DISCONNECTED, (Object)scorer.determineStatus());
    }

    @Test
    void calculateScoreWithNoLatencyData() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertEquals((double)80.0, (double)score, (double)0.1);
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)scorer.determineStatus());
    }

    @Test
    void calculateScoreWithNoOperationData() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 0L, 0L, 0L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertEquals((double)50.0, (double)score, (double)0.1);
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)scorer.determineStatus());
    }

    @Test
    void latencyScoreAtTargetSLO() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(500L), 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        Assertions.assertEquals((double)100.0, (double)scorer.calculateScore(), (double)0.1);
    }

    @Test
    void latencyScoreBetweenTargetAndMax() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(2750L), 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        double score = scorer.calculateScore();
        Assertions.assertTrue((score >= 60.0 && score <= 75.0 ? 1 : 0) != 0, (String)"Score should be in degraded range");
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)scorer.determineStatus());
    }

    @Test
    void latencyScoreAboveMaxTolerable() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofSeconds(10L), 100L, 100L, 10L, 10L, Instant.now());
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        Assertions.assertEquals((double)60.0, (double)scorer.calculateScore(), (double)0.1);
    }

    @Test
    void successRateScoreDirectlyProportional() {
        RelayMetrics perfect = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 100L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)100.0, (double)new RelayHealthScorer(perfect).calculateScore(), (double)0.1);
        RelayMetrics good = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 75L, 100L, 10L, 10L, Instant.now());
        double goodScore = new RelayHealthScorer(good).calculateScore();
        Assertions.assertEquals((double)90.0, (double)goodScore, (double)0.1);
        RelayMetrics poor = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 25L, 100L, 10L, 10L, Instant.now());
        double poorScore = new RelayHealthScorer(poor).calculateScore();
        Assertions.assertEquals((double)70.0, (double)poorScore, (double)0.1);
    }

    @Test
    void availabilityScoreDirectlyProportional() {
        RelayMetrics perfect = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 100L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)100.0, (double)new RelayHealthScorer(perfect).calculateScore(), (double)0.1);
        RelayMetrics degraded = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 100L, 100L, 5L, 10L, Instant.now());
        double degradedScore = new RelayHealthScorer(degraded).calculateScore();
        Assertions.assertEquals((double)90.0, (double)degradedScore, (double)0.1);
        RelayMetrics unavailable = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 100L, 100L, 0L, 10L, Instant.now());
        double unavailableScore = new RelayHealthScorer(unavailable).calculateScore();
        Assertions.assertEquals((double)80.0, (double)unavailableScore, (double)0.1);
    }

    @Test
    void statusThresholdsCorrectlyClassify() {
        RelayMetrics atConnectedThreshold = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 50L, 100L, 5L, 10L, Instant.now());
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)new RelayHealthScorer(atConnectedThreshold).determineStatus());
        RelayMetrics justBelowConnected = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 49L, 100L, 5L, 10L, Instant.now());
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)new RelayHealthScorer(justBelowConnected).determineStatus());
        RelayMetrics atDegradedThreshold = new RelayMetrics("wss://relay.example", Duration.ofSeconds(4L), 50L, 100L, 5L, 10L, Instant.now());
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)new RelayHealthScorer(atDegradedThreshold).determineStatus());
        RelayMetrics justBelowDegraded = new RelayMetrics("wss://relay.example", Duration.ofSeconds(6L), 47L, 100L, 5L, 10L, Instant.now());
        Assertions.assertEquals((Object)RelayStatus.DISCONNECTED, (Object)new RelayHealthScorer(justBelowDegraded).determineStatus());
    }

    @Test
    void toScoreSummaryIncludesAllComponents() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", Duration.ofMillis(200L), 80L, 100L, 8L, 10L, Instant.now());
        String summary = new RelayHealthScorer(metrics).toScoreSummary();
        Assertions.assertTrue((boolean)summary.contains("overall="));
        Assertions.assertTrue((boolean)summary.contains("latency="));
        Assertions.assertTrue((boolean)summary.contains("successRate="));
        Assertions.assertTrue((boolean)summary.contains("availability="));
        Assertions.assertTrue((boolean)summary.contains("status="));
        Assertions.assertTrue((summary.contains("CONNECTED") || summary.contains("DEGRADED") || summary.contains("DISCONNECTED") ? 1 : 0) != 0);
    }

    @Test
    void constructorRejectsNullMetrics() {
        Assertions.assertThrows(NullPointerException.class, () -> new RelayHealthScorer(null));
    }

    @Test
    void metricsAccessor() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        Assertions.assertEquals((Object)metrics, (Object)scorer.metrics());
    }
}

