/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;

class RelayMetricsTest {
    RelayMetricsTest() {
    }

    @Test
    void constructorValidatesSuccessfulOperations() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, -1L, 10L, 0L, 0L, Instant.now()));
    }

    @Test
    void constructorValidatesTotalOperations() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, 0L, -1L, 0L, 0L, Instant.now()));
    }

    @Test
    void constructorValidatesSuccessfulNotGreaterThanTotal() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, 100L, 50L, 0L, 0L, Instant.now()));
    }

    @Test
    void constructorValidatesSuccessfulConnections() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, 0L, 0L, -1L, 10L, Instant.now()));
    }

    @Test
    void constructorValidatesConnectionAttempts() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, 0L, 0L, 0L, -1L, Instant.now()));
    }

    @Test
    void constructorValidatesConnectionSuccessNotGreaterThanAttempts() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayMetrics("wss://relay.example", null, 0L, 0L, 10L, 5L, Instant.now()));
    }

    @Test
    void constructorRejectsNullRelayUrl() {
        Assertions.assertThrows(NullPointerException.class, () -> new RelayMetrics(null, null, 0L, 0L, 0L, 0L, Instant.now()));
    }

    @Test
    void constructorRejectsNullCapturedAt() {
        Assertions.assertThrows(NullPointerException.class, () -> new RelayMetrics("wss://relay.example", null, 0L, 0L, 0L, 0L, null));
    }

    @Test
    void initialCreatesZeroedMetrics() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        Assertions.assertEquals((Object)"wss://relay.example", (Object)metrics.relayUrl());
        Assertions.assertNull((Object)metrics.p95Latency());
        Assertions.assertEquals((long)0L, (long)metrics.successfulOperations());
        Assertions.assertEquals((long)0L, (long)metrics.totalOperations());
        Assertions.assertEquals((long)0L, (long)metrics.successfulConnections());
        Assertions.assertEquals((long)0L, (long)metrics.connectionAttempts());
        Assertions.assertNotNull((Object)metrics.capturedAt());
    }

    @Test
    void failureRateCalculation() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 75L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)0.25, (double)metrics.failureRate(), (double)0.001);
    }

    @Test
    void failureRateZeroWhenNoOperations() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        Assertions.assertEquals((double)0.0, (double)metrics.failureRate(), (double)0.001);
    }

    @Test
    void successRateCalculation() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 80L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)0.8, (double)metrics.successRate(), (double)0.001);
    }

    @Test
    void successRateZeroWhenNoOperations() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        Assertions.assertEquals((double)0.0, (double)metrics.successRate(), (double)0.001);
    }

    @Test
    void connectionSuccessRateCalculation() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 0L, 7L, 10L, Instant.now());
        Assertions.assertEquals((double)0.7, (double)metrics.connectionSuccessRate(), (double)0.001);
    }

    @Test
    void connectionSuccessRateZeroWhenNoAttempts() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        Assertions.assertEquals((double)0.0, (double)metrics.connectionSuccessRate(), (double)0.001);
    }

    @Test
    void hasSufficientDataReturnsFalseInitially() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example");
        Assertions.assertFalse((boolean)metrics.hasSufficientData());
    }

    @Test
    void hasSufficientDataReturnsFalseWithOnlyConnections() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 0L, 5L, 10L, Instant.now());
        Assertions.assertFalse((boolean)metrics.hasSufficientData());
    }

    @Test
    void hasSufficientDataReturnsFalseWithOnlyOperations() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 10L, 10L, 0L, 0L, Instant.now());
        Assertions.assertFalse((boolean)metrics.hasSufficientData());
    }

    @Test
    void hasSufficientDataReturnsTrueWithBoth() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 10L, 10L, 5L, 10L, Instant.now());
        Assertions.assertTrue((boolean)metrics.hasSufficientData());
    }

    @Test
    void withOperationSuccessIncrementsCounters() {
        RelayMetrics initial = RelayMetrics.initial((String)"wss://relay.example");
        RelayMetrics updated = initial.withOperation(true, Duration.ofMillis(100L));
        Assertions.assertEquals((long)1L, (long)updated.successfulOperations());
        Assertions.assertEquals((long)1L, (long)updated.totalOperations());
        Assertions.assertEquals((Object)Duration.ofMillis(100L), (Object)updated.p95Latency());
    }

    @Test
    void withOperationFailureIncrementsOnlyTotal() {
        RelayMetrics initial = RelayMetrics.initial((String)"wss://relay.example");
        RelayMetrics updated = initial.withOperation(false, Duration.ofMillis(200L));
        Assertions.assertEquals((long)0L, (long)updated.successfulOperations());
        Assertions.assertEquals((long)1L, (long)updated.totalOperations());
        Assertions.assertEquals((Object)Duration.ofMillis(200L), (Object)updated.p95Latency());
    }

    @Test
    void withOperationNullLatencyPreservesExisting() {
        RelayMetrics initial = new RelayMetrics("wss://relay.example", Duration.ofMillis(100L), 5L, 10L, 5L, 10L, Instant.now());
        RelayMetrics updated = initial.withOperation(true, null);
        Assertions.assertEquals((Object)Duration.ofMillis(100L), (Object)updated.p95Latency());
        Assertions.assertEquals((long)6L, (long)updated.successfulOperations());
        Assertions.assertEquals((long)11L, (long)updated.totalOperations());
    }

    @Test
    void withConnectionAttemptSuccessIncrementsCounters() {
        RelayMetrics initial = RelayMetrics.initial((String)"wss://relay.example");
        RelayMetrics updated = initial.withConnectionAttempt(true);
        Assertions.assertEquals((long)1L, (long)updated.successfulConnections());
        Assertions.assertEquals((long)1L, (long)updated.connectionAttempts());
    }

    @Test
    void withConnectionAttemptFailureIncrementsOnlyTotal() {
        RelayMetrics initial = RelayMetrics.initial((String)"wss://relay.example");
        RelayMetrics updated = initial.withConnectionAttempt(false);
        Assertions.assertEquals((long)0L, (long)updated.successfulConnections());
        Assertions.assertEquals((long)1L, (long)updated.connectionAttempts());
    }

    @Test
    void multipleUpdatesChain() {
        RelayMetrics metrics = RelayMetrics.initial((String)"wss://relay.example").withConnectionAttempt(true).withOperation(true, Duration.ofMillis(50L)).withOperation(true, Duration.ofMillis(100L)).withOperation(false, Duration.ofMillis(500L));
        Assertions.assertEquals((long)2L, (long)metrics.successfulOperations());
        Assertions.assertEquals((long)3L, (long)metrics.totalOperations());
        Assertions.assertEquals((long)1L, (long)metrics.successfulConnections());
        Assertions.assertEquals((long)1L, (long)metrics.connectionAttempts());
        Assertions.assertEquals((Object)Duration.ofMillis(500L), (Object)metrics.p95Latency());
    }

    @Test
    void capturedAtUpdatesOnMutation() {
        Instant before = Instant.now();
        RelayMetrics initial = RelayMetrics.initial((String)"wss://relay.example");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RelayMetrics updated = initial.withOperation(true, Duration.ofMillis(100L));
        Assertions.assertTrue((boolean)updated.capturedAt().isAfter(before));
    }

    @Test
    void edgeCaseAllOperationsSucceed() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 100L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)0.0, (double)metrics.failureRate(), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)metrics.successRate(), (double)0.001);
    }

    @Test
    void edgeCaseAllOperationsFail() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 100L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)1.0, (double)metrics.failureRate(), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)metrics.successRate(), (double)0.001);
    }

    @Test
    void edgeCaseAllConnectionsSucceed() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 0L, 10L, 10L, Instant.now());
        Assertions.assertEquals((double)1.0, (double)metrics.connectionSuccessRate(), (double)0.001);
    }

    @Test
    void edgeCaseAllConnectionsFail() {
        RelayMetrics metrics = new RelayMetrics("wss://relay.example", null, 0L, 0L, 0L, 10L, Instant.now());
        Assertions.assertEquals((double)0.0, (double)metrics.connectionSuccessRate(), (double)0.001);
    }
}

