/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.EvictedRelay;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;

class RelayReEvaluatorTest {
    private RelayReEvaluator evaluator;

    RelayReEvaluatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.evaluator = new RelayReEvaluator();
    }

    @Test
    void constructorWithDefaultSettings() {
        RelayReEvaluator defaultEvaluator = new RelayReEvaluator();
        Assertions.assertEquals((Object)RelayReEvaluator.DEFAULT_RETRY_INTERVAL, (Object)defaultEvaluator.getRetryInterval());
        Assertions.assertEquals((int)5, (int)defaultEvaluator.getMaxRetryCount());
    }

    @Test
    void constructorWithCustomSettings() {
        Duration customInterval = Duration.ofMinutes(10L);
        int customMaxRetries = 3;
        RelayReEvaluator customEvaluator = new RelayReEvaluator(customInterval, customMaxRetries);
        Assertions.assertEquals((Object)customInterval, (Object)customEvaluator.getRetryInterval());
        Assertions.assertEquals((int)customMaxRetries, (int)customEvaluator.getMaxRetryCount());
    }

    @Test
    void constructorRejectsNegativeMaxRetries() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RelayReEvaluator(Duration.ofMinutes(5L), -1));
    }

    @Test
    void evictRelayTracksEviction() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        Assertions.assertTrue((boolean)this.evaluator.isEvicted("wss://relay.example"));
        Assertions.assertEquals((int)1, (int)this.evaluator.getEvictedCount());
    }

    @Test
    void evictRelayCreatesRecord() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        EvictedRelay record = this.evaluator.getEvictionRecord("wss://relay.example");
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals((Object)"wss://relay.example", (Object)record.relayUrl());
        Assertions.assertEquals((double)25.0, (double)record.evictionScore());
        Assertions.assertEquals((int)0, (int)record.retryCount());
    }

    @Test
    void getEligibleForRetryReturnsEmptyInitially() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        Map eligible = this.evaluator.getEligibleForRetry();
        Assertions.assertTrue((boolean)eligible.isEmpty());
    }

    @Test
    void getEligibleForRetryWithShortInterval() {
        RelayReEvaluator shortIntervalEvaluator = new RelayReEvaluator(Duration.ofMillis(10L), 5);
        shortIntervalEvaluator.evictRelay("wss://relay.example", 25.0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map eligible = shortIntervalEvaluator.getEligibleForRetry();
        Assertions.assertEquals((int)1, (int)eligible.size());
        Assertions.assertTrue((boolean)eligible.containsKey("wss://relay.example"));
    }

    @Test
    void getEligibleForRetryExcludesMaxRetries() {
        RelayReEvaluator shortIntervalEvaluator = new RelayReEvaluator(Duration.ofMillis(10L), 2);
        shortIntervalEvaluator.evictRelay("wss://relay.example", 25.0);
        shortIntervalEvaluator.recordRetryAttempt("wss://relay.example");
        shortIntervalEvaluator.recordRetryAttempt("wss://relay.example");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map eligible = shortIntervalEvaluator.getEligibleForRetry();
        Assertions.assertTrue((boolean)eligible.isEmpty(), (String)"Relays with max retries exceeded should not be eligible");
    }

    @Test
    void recordRetryAttemptIncrementsCount() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        this.evaluator.recordRetryAttempt("wss://relay.example");
        EvictedRelay record = this.evaluator.getEvictionRecord("wss://relay.example");
        Assertions.assertEquals((int)1, (int)record.retryCount());
    }

    @Test
    void recordRetryAttemptMultipleTimes() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        this.evaluator.recordRetryAttempt("wss://relay.example");
        this.evaluator.recordRetryAttempt("wss://relay.example");
        this.evaluator.recordRetryAttempt("wss://relay.example");
        EvictedRelay record = this.evaluator.getEvictionRecord("wss://relay.example");
        Assertions.assertEquals((int)3, (int)record.retryCount());
    }

    @Test
    void recordRetryAttemptForNonEvictedRelay() {
        this.evaluator.recordRetryAttempt("wss://unknown.example");
        Assertions.assertNull((Object)this.evaluator.getEvictionRecord("wss://unknown.example"));
    }

    @Test
    void promoteRelayRemovesFromTracking() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        boolean promoted = this.evaluator.promoteRelay("wss://relay.example");
        Assertions.assertTrue((boolean)promoted);
        Assertions.assertFalse((boolean)this.evaluator.isEvicted("wss://relay.example"));
        Assertions.assertEquals((int)0, (int)this.evaluator.getEvictedCount());
    }

    @Test
    void promoteRelayReturnsFalseForNonEvicted() {
        boolean promoted = this.evaluator.promoteRelay("wss://unknown.example");
        Assertions.assertFalse((boolean)promoted);
    }

    @Test
    void abandonRelayRemovesFromTracking() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        boolean abandoned = this.evaluator.abandonRelay("wss://relay.example");
        Assertions.assertTrue((boolean)abandoned);
        Assertions.assertFalse((boolean)this.evaluator.isEvicted("wss://relay.example"));
        Assertions.assertEquals((int)0, (int)this.evaluator.getEvictedCount());
    }

    @Test
    void abandonRelayReturnsFalseForNonEvicted() {
        boolean abandoned = this.evaluator.abandonRelay("wss://unknown.example");
        Assertions.assertFalse((boolean)abandoned);
    }

    @Test
    void isEvictedReturnsFalseForNonEvicted() {
        Assertions.assertFalse((boolean)this.evaluator.isEvicted("wss://unknown.example"));
    }

    @Test
    void getEvictionRecordReturnsNullForNonEvicted() {
        Assertions.assertNull((Object)this.evaluator.getEvictionRecord("wss://unknown.example"));
    }

    @Test
    void performReEvaluationWithNoEligibleRelays() {
        this.evaluator.evictRelay("wss://relay.example", 25.0);
        AtomicInteger handlerCalls = new AtomicInteger();
        int attempted = this.evaluator.performReEvaluation(url -> handlerCalls.incrementAndGet());
        Assertions.assertEquals((int)0, (int)attempted);
        Assertions.assertEquals((int)0, (int)handlerCalls.get());
    }

    @Test
    void performReEvaluationWithEligibleRelays() {
        RelayReEvaluator shortIntervalEvaluator = new RelayReEvaluator(Duration.ofMillis(10L), 5);
        shortIntervalEvaluator.evictRelay("wss://relay1.example", 25.0);
        shortIntervalEvaluator.evictRelay("wss://relay2.example", 28.0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AtomicInteger handlerCalls = new AtomicInteger();
        int attempted = shortIntervalEvaluator.performReEvaluation(url -> handlerCalls.incrementAndGet());
        Assertions.assertEquals((int)2, (int)attempted);
        Assertions.assertEquals((int)2, (int)handlerCalls.get());
    }

    @Test
    void performReEvaluationRecordsRetryAttempts() {
        RelayReEvaluator shortIntervalEvaluator = new RelayReEvaluator(Duration.ofMillis(10L), 5);
        shortIntervalEvaluator.evictRelay("wss://relay.example", 25.0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        shortIntervalEvaluator.performReEvaluation(url -> {});
        EvictedRelay record = shortIntervalEvaluator.getEvictionRecord("wss://relay.example");
        Assertions.assertEquals((int)1, (int)record.retryCount());
    }

    @Test
    void performReEvaluationHandlesExceptions() {
        RelayReEvaluator shortIntervalEvaluator = new RelayReEvaluator(Duration.ofMillis(10L), 5);
        shortIntervalEvaluator.evictRelay("wss://relay.example", 25.0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int attempted = shortIntervalEvaluator.performReEvaluation(url -> {
            throw new RuntimeException("Simulated failure");
        });
        Assertions.assertEquals((int)1, (int)attempted);
        Assertions.assertTrue((boolean)shortIntervalEvaluator.isEvicted("wss://relay.example"));
    }

    @Test
    void methodsRejectNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.evictRelay(null, 25.0));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.recordRetryAttempt(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.promoteRelay(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.abandonRelay(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.isEvicted(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.getEvictionRecord(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.evaluator.performReEvaluation(null));
        Assertions.assertThrows(NullPointerException.class, () -> new RelayReEvaluator(null, 5));
    }

    @Test
    void getEvictedCountReflectsState() {
        Assertions.assertEquals((int)0, (int)this.evaluator.getEvictedCount());
        this.evaluator.evictRelay("wss://relay1.example", 25.0);
        Assertions.assertEquals((int)1, (int)this.evaluator.getEvictedCount());
        this.evaluator.evictRelay("wss://relay2.example", 28.0);
        Assertions.assertEquals((int)2, (int)this.evaluator.getEvictedCount());
        this.evaluator.promoteRelay("wss://relay1.example");
        Assertions.assertEquals((int)1, (int)this.evaluator.getEvictedCount());
    }
}

