/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySet;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

class RelaySetTest {
    RelaySetTest() {
    }

    @Test
    void constructorWithSeparateReadWriteRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write1.example.com"), RelayConnection.connected((String)"wss://write2.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read1.example.com"), RelayConnection.connected((String)"wss://read2.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        Assertions.assertEquals((int)2, (int)relaySet.writeRelays().size());
        Assertions.assertEquals((int)2, (int)relaySet.readRelays().size());
        Assertions.assertEquals((int)4, (int)relaySet.totalRelayCount());
        Assertions.assertTrue((boolean)relaySet.isSegregated());
    }

    @Test
    void constructorWithUnifiedRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.example.com"), RelayConnection.connected((String)"wss://relay2.example.com"));
        RelaySet relaySet = new RelaySet(relays);
        Assertions.assertEquals((int)2, (int)relaySet.writeRelays().size());
        Assertions.assertEquals((int)2, (int)relaySet.readRelays().size());
        Assertions.assertEquals((int)2, (int)relaySet.totalRelayCount());
        Assertions.assertFalse((boolean)relaySet.isSegregated());
    }

    @Test
    void constructorWithOverlappingReadWriteRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://shared.example.com"), RelayConnection.connected((String)"wss://write-only.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://shared.example.com"), RelayConnection.connected((String)"wss://read-only.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        Assertions.assertEquals((int)2, (int)relaySet.writeRelays().size());
        Assertions.assertEquals((int)2, (int)relaySet.readRelays().size());
        Assertions.assertEquals((int)3, (int)relaySet.totalRelayCount());
        Assertions.assertTrue((boolean)relaySet.isSegregated());
    }

    @Test
    void constructorAllowsEmptyWriteRelaysForDegradedMode() {
        List writeRelays = List.of();
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        Assertions.assertTrue((boolean)relaySet.writeRelays().isEmpty());
        Assertions.assertEquals((int)1, (int)relaySet.readRelays().size());
    }

    @Test
    void constructorAllowsEmptyReadRelaysForDegradedMode() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write.example.com"));
        List readRelays = List.of();
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        Assertions.assertEquals((int)1, (int)relaySet.writeRelays().size());
        Assertions.assertTrue((boolean)relaySet.readRelays().isEmpty());
    }

    @Test
    void constructorAllowsBothEmptyRelaysForDegradedMode() {
        List writeRelays = List.of();
        List readRelays = List.of();
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        Assertions.assertTrue((boolean)relaySet.writeRelays().isEmpty());
        Assertions.assertTrue((boolean)relaySet.readRelays().isEmpty());
        Assertions.assertTrue((boolean)relaySet.allRelays().isEmpty());
        Assertions.assertEquals((int)0, (int)relaySet.totalRelayCount());
    }

    @Test
    void constructorRejectsNullWriteRelays() {
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read.example.com"));
        Assertions.assertThrows(NullPointerException.class, () -> new RelaySet(null, (Collection)readRelays));
    }

    @Test
    void constructorRejectsNullReadRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write.example.com"));
        Assertions.assertThrows(NullPointerException.class, () -> new RelaySet((Collection)writeRelays, null));
    }

    @Test
    void getRelaysForPublishReturnsWriteRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        List result = relaySet.getRelaysFor(RelaySelectionPolicy.OperationType.PUBLISH);
        Assertions.assertEquals(writeRelays, (Object)result);
    }

    @Test
    void getRelaysForSubscribeReturnsReadRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        List result = relaySet.getRelaysFor(RelaySelectionPolicy.OperationType.SUBSCRIBE);
        Assertions.assertEquals(readRelays, (Object)result);
    }

    @Test
    void getRelaysForQueryReturnsReadRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        List result = relaySet.getRelaysFor(RelaySelectionPolicy.OperationType.QUERY);
        Assertions.assertEquals(readRelays, (Object)result);
    }

    @Test
    void getRelaysForRejectsNull() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay.example.com")));
        Assertions.assertThrows(NullPointerException.class, () -> relaySet.getRelaysFor(null));
    }

    @Test
    void allRelaysReturnsUnmodifiableList() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay.example.com")));
        List allRelays = relaySet.allRelays();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> allRelays.add(RelayConnection.connected((String)"wss://new.example.com")));
    }

    @Test
    void writeRelaysReturnsUnmodifiableList() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay.example.com")));
        List writeRelays = relaySet.writeRelays();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> writeRelays.add(RelayConnection.connected((String)"wss://new.example.com")));
    }

    @Test
    void readRelaysReturnsUnmodifiableList() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay.example.com")));
        List readRelays = relaySet.readRelays();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readRelays.add(RelayConnection.connected((String)"wss://new.example.com")));
    }

    @Test
    void withUpdatedStatusesUpdatesExistingRelays() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://write.example.com")), List.of(RelayConnection.connected((String)"wss://read.example.com")));
        List<RelayConnection> updatedRelays = List.of(RelayConnection.degraded((String)"wss://write.example.com"), RelayConnection.disconnected((String)"wss://read.example.com"));
        RelaySet updated = relaySet.withUpdatedStatuses(updatedRelays);
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)((RelayConnection)updated.writeRelays().get(0)).status());
        Assertions.assertEquals((Object)RelayStatus.DISCONNECTED, (Object)((RelayConnection)updated.readRelays().get(0)).status());
    }

    @Test
    void withUpdatedStatusesPreservesRelaysNotInUpdate() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://write1.example.com"), RelayConnection.connected((String)"wss://write2.example.com")), List.of(RelayConnection.connected((String)"wss://read.example.com")));
        List<RelayConnection> updatedRelays = List.of(RelayConnection.degraded((String)"wss://write1.example.com"));
        RelaySet updated = relaySet.withUpdatedStatuses(updatedRelays);
        Assertions.assertEquals((Object)RelayStatus.DEGRADED, (Object)((RelayConnection)updated.writeRelays().get(0)).status());
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)((RelayConnection)updated.writeRelays().get(1)).status());
    }

    @Test
    void withUpdatedStatusesRejectsNull() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay.example.com")));
        Assertions.assertThrows(NullPointerException.class, () -> relaySet.withUpdatedStatuses(null));
    }

    @Test
    void toStringForSegregatedSet() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://write1.example.com"), RelayConnection.connected((String)"wss://write2.example.com")), List.of(RelayConnection.connected((String)"wss://read.example.com")));
        String result = relaySet.toString();
        Assertions.assertTrue((boolean)result.contains("write=2"));
        Assertions.assertTrue((boolean)result.contains("read=1"));
        Assertions.assertTrue((boolean)result.contains("total=3"));
    }

    @Test
    void toStringForUnifiedSet() {
        RelaySet relaySet = new RelaySet(List.of(RelayConnection.connected((String)"wss://relay1.example.com"), RelayConnection.connected((String)"wss://relay2.example.com")));
        String result = relaySet.toString();
        Assertions.assertTrue((boolean)result.contains("unified=2"));
        Assertions.assertFalse((boolean)result.contains("write="));
        Assertions.assertFalse((boolean)result.contains("read="));
    }

    @Test
    void allRelaysOrderPrefersWriteRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://write1.example.com"), RelayConnection.connected((String)"wss://write2.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://read1.example.com"), RelayConnection.connected((String)"wss://read2.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        List allRelays = relaySet.allRelays();
        Assertions.assertEquals((Object)"wss://write1.example.com", (Object)((RelayConnection)allRelays.get(0)).url());
        Assertions.assertEquals((Object)"wss://write2.example.com", (Object)((RelayConnection)allRelays.get(1)).url());
    }

    @Test
    void allRelaysDeduplicatesSharedRelays() {
        List<RelayConnection> writeRelays = List.of(RelayConnection.connected((String)"wss://shared.example.com"), RelayConnection.connected((String)"wss://write.example.com"));
        List<RelayConnection> readRelays = List.of(RelayConnection.connected((String)"wss://shared.example.com"), RelayConnection.connected((String)"wss://read.example.com"));
        RelaySet relaySet = new RelaySet(writeRelays, readRelays);
        List allRelays = relaySet.allRelays();
        Assertions.assertEquals((int)3, (int)allRelays.size());
        long sharedCount = allRelays.stream().filter(relay -> relay.url().equals("wss://shared.example.com")).count();
        Assertions.assertEquals((long)1L, (long)sharedCount, (String)"Shared relay should appear exactly once");
    }
}

