/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelayTelemetry;
import xyz.tcheeric.wallet.core.nostr.relay.RelayTelemetryCollector;

class RelayTelemetryCollectorTest {
    private RelayHealthMonitor healthMonitor;
    private RelayReEvaluator reEvaluator;

    RelayTelemetryCollectorTest() {
    }

    @BeforeEach
    void setUp() {
        this.healthMonitor = new RelayHealthMonitor();
        this.reEvaluator = new RelayReEvaluator();
    }

    @Test
    void collectorDisabledByDefault() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator);
        Assertions.assertFalse((boolean)collector.isEnabled());
    }

    @Test
    void collectorCanBeEnabled() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        Assertions.assertTrue((boolean)collector.isEnabled());
    }

    @Test
    void collectReturnsEmptyWhenDisabled() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, false);
        RelayTelemetry telemetry = collector.collect();
        Assertions.assertEquals((int)0, (int)telemetry.totalRelays());
        Assertions.assertEquals((int)0, (int)telemetry.connectedRelays());
        Assertions.assertEquals((int)0, (int)telemetry.evictedRelays());
    }

    @Test
    void collectGathersStatsWhenEnabled() {
        int i;
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        this.healthMonitor.registerRelay("wss://relay1.example");
        this.healthMonitor.recordConnectionAttempt("wss://relay1.example", true);
        for (i = 0; i < 100; ++i) {
            this.healthMonitor.recordOperation("wss://relay1.example", true, Duration.ofMillis(100L));
        }
        this.healthMonitor.registerRelay("wss://relay2.example");
        this.healthMonitor.recordConnectionAttempt("wss://relay2.example", true);
        for (i = 0; i < 100; ++i) {
            this.healthMonitor.recordOperation("wss://relay2.example", i < 50, Duration.ofMillis(500L));
        }
        this.reEvaluator.evictRelay("wss://evicted.example", 20.0);
        RelayTelemetry telemetry = collector.collect();
        Assertions.assertEquals((int)2, (int)telemetry.totalRelays());
        Assertions.assertEquals((int)1, (int)telemetry.evictedRelays());
        Assertions.assertTrue((telemetry.averageHealthScore() > 0.0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)telemetry.averageLatencyMs());
        Assertions.assertTrue((telemetry.totalOperations() > 0L ? 1 : 0) != 0);
    }

    @Test
    void collectAggregatesCorrectly() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        this.healthMonitor.registerRelay("wss://perfect.example");
        this.healthMonitor.recordConnectionAttempt("wss://perfect.example", true);
        for (int i = 0; i < 100; ++i) {
            this.healthMonitor.recordOperation("wss://perfect.example", true, Duration.ofMillis(100L));
        }
        RelayTelemetry telemetry = collector.collect();
        Assertions.assertEquals((int)1, (int)telemetry.totalRelays());
        Assertions.assertEquals((long)100L, (long)telemetry.totalOperations());
        Assertions.assertEquals((long)0L, (long)telemetry.totalFailures());
        Assertions.assertEquals((double)1.0, (double)telemetry.overallSuccessRate(), (double)0.001);
        Assertions.assertEquals((double)100.0, (double)telemetry.averageLatencyMs(), (double)1.0);
    }

    @Test
    void collectCountsRelayStatuses() {
        int i;
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        this.healthMonitor.registerRelay("wss://connected.example");
        this.healthMonitor.recordConnectionAttempt("wss://connected.example", true);
        for (i = 0; i < 100; ++i) {
            this.healthMonitor.recordOperation("wss://connected.example", true, Duration.ofMillis(100L));
        }
        this.healthMonitor.registerRelay("wss://degraded.example");
        this.healthMonitor.recordConnectionAttempt("wss://degraded.example", true);
        for (i = 0; i < 100; ++i) {
            this.healthMonitor.recordOperation("wss://degraded.example", i < 70, Duration.ofMillis(500L));
        }
        RelayTelemetry telemetry = collector.collect();
        Assertions.assertEquals((int)2, (int)telemetry.totalRelays());
        Assertions.assertTrue((telemetry.connectedRelays() + telemetry.degradedRelays() >= 1 ? 1 : 0) != 0);
    }

    @Test
    void collectAndLogWorksWhenEnabled() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        this.healthMonitor.registerRelay("wss://relay.example");
        this.healthMonitor.recordConnectionAttempt("wss://relay.example", true);
        this.healthMonitor.recordOperation("wss://relay.example", true, Duration.ofMillis(100L));
        Assertions.assertDoesNotThrow(() -> collector.collectAndLog());
    }

    @Test
    void collectAndLogNoOpWhenDisabled() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, false);
        Assertions.assertDoesNotThrow(() -> collector.collectAndLog());
    }

    @Test
    void telemetryWithoutLatency() {
        RelayTelemetryCollector collector = new RelayTelemetryCollector(this.healthMonitor, this.reEvaluator, true);
        this.healthMonitor.registerRelay("wss://relay.example");
        this.healthMonitor.recordConnectionAttempt("wss://relay.example", true);
        this.healthMonitor.recordOperation("wss://relay.example", true, null);
        RelayTelemetry telemetry = collector.collect();
        Assertions.assertNull((Object)telemetry.averageLatencyMs());
    }

    @Test
    void constructorRejectsNullMonitor() {
        Assertions.assertThrows(NullPointerException.class, () -> new RelayTelemetryCollector(null, this.reEvaluator));
    }

    @Test
    void constructorRejectsNullReEvaluator() {
        Assertions.assertThrows(NullPointerException.class, () -> new RelayTelemetryCollector(this.healthMonitor, null));
    }
}

