/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;
import xyz.tcheeric.wallet.core.nostr.relay.StickyRelayPolicy;

class StickyRelayPolicyTest {
    private StickyRelayPolicy policy;

    StickyRelayPolicyTest() {
    }

    @BeforeEach
    void setUp() {
        this.policy = new StickyRelayPolicy();
    }

    @Test
    void selectWithEmptyRelaysThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select(List.of(), 1, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectWithZeroCountThrowsException() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select((Collection)relays, 0, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectWithNegativeCountThrowsException() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.policy.select((Collection)relays, -1, RelaySelectionPolicy.SelectionContext.forPublish()));
    }

    @Test
    void selectSingleRelay() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://relay1.com", (Object)((RelayConnection)selected.get(0)).url());
    }

    @Test
    void selectPrefersHealthyRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.degraded((String)"wss://degraded.com"), RelayConnection.connected((String)"wss://healthy.com"));
        List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://healthy.com", (Object)((RelayConnection)selected.get(0)).url());
        Assertions.assertEquals((Object)RelayStatus.CONNECTED, (Object)((RelayConnection)selected.get(0)).status());
    }

    @Test
    void selectPrefersStickyRelaysOverNew() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        List firstSelection = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        String firstUrl = ((RelayConnection)firstSelection.get(0)).url();
        List secondSelection = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((Object)firstUrl, (Object)((RelayConnection)secondSelection.get(0)).url(), (String)"Should select same relay (sticky behavior)");
        List thirdSelection = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((Object)firstUrl, (Object)((RelayConnection)thirdSelection.get(0)).url(), (String)"Should maintain sticky preference");
    }

    @Test
    void selectExpandsToNewRelaysWhenNeeded() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        List selected = this.policy.select(relays, 3, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)3, (int)selected.size());
        Assertions.assertEquals((long)3L, (long)selected.stream().map(RelayConnection::url).distinct().count());
    }

    @Test
    void selectPrefersStickyHealthyOverStickyDegraded() {
        List<RelayConnection> initialRelays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        this.policy.select(initialRelays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        List<RelayConnection> relays = List.of(RelayConnection.degraded((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"));
        List selected = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((Object)"wss://relay1.com", (Object)((RelayConnection)selected.get(0)).url());
    }

    @Test
    void selectSkipsDisconnectedRelays() {
        List<RelayConnection> relays = List.of(RelayConnection.disconnected((String)"wss://offline.com"), RelayConnection.connected((String)"wss://online.com"));
        List selected = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)selected.size());
        Assertions.assertEquals((Object)"wss://online.com", (Object)((RelayConnection)selected.get(0)).url());
    }

    @Test
    void selectIncludesDegradedRelaysWhenNoHealthyAvailable() {
        List<RelayConnection> relays = List.of(RelayConnection.degraded((String)"wss://degraded1.com"), RelayConnection.degraded((String)"wss://degraded2.com"));
        List selected = this.policy.select(relays, 2, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)2, (int)selected.size());
        Assertions.assertTrue((boolean)selected.stream().allMatch(r -> r.status() == RelayStatus.DEGRADED));
    }

    @Test
    void selectReturnsLessThanRequestedWhenInsufficientAvailable() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"));
        List selected = this.policy.select(relays, 5, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)2, (int)selected.size(), (String)"Should return only available relays");
    }

    @Test
    void clearStickyStateResetsPreferences() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"));
        List firstSelection = this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        String firstUrl = ((RelayConnection)firstSelection.get(0)).url();
        this.policy.clearStickyState();
        Assertions.assertEquals((int)0, (int)this.policy.getSelectionCount(firstUrl));
    }

    @Test
    void getSelectionCountTracksUsage() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"));
        Assertions.assertEquals((int)0, (int)this.policy.getSelectionCount("wss://relay1.com"));
        this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)1, (int)this.policy.getSelectionCount("wss://relay1.com"));
        this.policy.select(relays, 1, RelaySelectionPolicy.SelectionContext.forPublish());
        Assertions.assertEquals((int)2, (int)this.policy.getSelectionCount("wss://relay1.com"));
    }

    @Test
    void selectMaintainsInsertionOrder() {
        List<RelayConnection> relays = List.of(RelayConnection.connected((String)"wss://relay1.com"), RelayConnection.connected((String)"wss://relay2.com"), RelayConnection.connected((String)"wss://relay3.com"));
        for (int i = 0; i < 3; ++i) {
            List selected = this.policy.select(relays, 3, RelaySelectionPolicy.SelectionContext.forPublish());
            Assertions.assertNotNull((Object)selected);
            Assertions.assertEquals((int)3, (int)selected.size());
        }
    }
}

