/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.voucher;

import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.wallet.core.nostr.voucher.VoucherConverter;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

class VoucherConverterTest {
    VoucherConverterTest() {
    }

    @Test
    void shouldConvertStoredVoucherToSignedVoucher() {
        StoredVoucher stored = new StoredVoucher("voucher-123", "issuer-pubkey-hex", "sat", 1000L, null, "Test voucher", "a".repeat(128), "issuer-pubkey-hex", Instant.now(), "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)stored);
        Assertions.assertThat((String)signed.getSecret().getVoucherId()).isEqualTo("voucher-123");
        Assertions.assertThat((String)signed.getSecret().getIssuerId()).isEqualTo("issuer-pubkey-hex");
        Assertions.assertThat((String)signed.getSecret().getUnit()).isEqualTo("sat");
        Assertions.assertThat((long)signed.getSecret().getFaceValue()).isEqualTo(1000L);
        Assertions.assertThat((Long)signed.getSecret().getExpiresAt()).isNull();
        Assertions.assertThat((String)signed.getSecret().getMemo()).isEqualTo("Test voucher");
        Assertions.assertThat((String)signed.getIssuerPublicKey()).isEqualTo("issuer-pubkey-hex");
        Assertions.assertThat((byte[])signed.getIssuerSignature()).hasSize(64);
    }

    @Test
    void shouldConvertSignedVoucherToStoredVoucher() {
        StoredVoucher original = new StoredVoucher("voucher-456", "issuer-pubkey-hex", "sat", 2000L, Long.valueOf(1234567890L), "Test voucher 2", "b".repeat(128), "issuer-pubkey-hex", Instant.now(), "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)original);
        Instant issuedAt = Instant.now();
        StoredVoucher stored = VoucherConverter.toStoredVoucher((SignedVoucher)signed, (String)"redeemed", (Instant)issuedAt);
        Assertions.assertThat((String)stored.voucherId()).isEqualTo("voucher-456");
        Assertions.assertThat((String)stored.issuerId()).isEqualTo("issuer-pubkey-hex");
        Assertions.assertThat((String)stored.unit()).isEqualTo("sat");
        Assertions.assertThat((long)stored.faceValue()).isEqualTo(2000L);
        Assertions.assertThat((Long)stored.expiresAt()).isEqualTo(1234567890L);
        Assertions.assertThat((String)stored.memo()).isEqualTo("Test voucher 2");
        Assertions.assertThat((String)stored.issuerSignature()).hasSize(128);
        Assertions.assertThat((String)stored.issuerPublicKey()).isEqualTo("issuer-pubkey-hex");
        Assertions.assertThat((String)stored.status()).isEqualTo("redeemed");
        Assertions.assertThat((Instant)stored.issuedAt()).isEqualTo((Object)issuedAt);
    }

    @Test
    void shouldPreserveDataThroughRoundTripConversion() {
        Instant originalIssuedAt = Instant.now();
        StoredVoucher original = new StoredVoucher("voucher-789", "issuer-xyz", "sat", 5000L, Long.valueOf(9999999999L), "Round trip test", "c".repeat(128), "issuer-xyz", originalIssuedAt, "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)original);
        StoredVoucher restored = VoucherConverter.toStoredVoucher((SignedVoucher)signed, (String)"issued", (Instant)originalIssuedAt);
        Assertions.assertThat((String)restored.voucherId()).isEqualTo(original.voucherId());
        Assertions.assertThat((String)restored.issuerId()).isEqualTo(original.issuerId());
        Assertions.assertThat((String)restored.unit()).isEqualTo(original.unit());
        Assertions.assertThat((long)restored.faceValue()).isEqualTo(original.faceValue());
        Assertions.assertThat((Long)restored.expiresAt()).isEqualTo((Object)original.expiresAt());
        Assertions.assertThat((String)restored.memo()).isEqualTo(original.memo());
        Assertions.assertThat((String)restored.issuerPublicKey()).isEqualTo(original.issuerPublicKey());
    }

    @Test
    void shouldHandleNullExpiry() {
        StoredVoucher stored = new StoredVoucher("no-expiry", "issuer", "sat", 100L, null, null, "d".repeat(128), "issuer", Instant.now(), "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)stored);
        Assertions.assertThat((Long)signed.getSecret().getExpiresAt()).isNull();
    }

    @Test
    void shouldHandleNullMemo() {
        StoredVoucher stored = new StoredVoucher("no-memo", "issuer", "sat", 100L, null, null, "e".repeat(128), "issuer", Instant.now(), "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)stored);
        Assertions.assertThat((String)signed.getSecret().getMemo()).isNull();
    }

    @Test
    void shouldUseDefaultStatusWhenNotSpecified() {
        StoredVoucher original = new StoredVoucher("default-test", "issuer", "sat", 500L, null, "Test", "f".repeat(128), "issuer", Instant.now(), "issued");
        SignedVoucher signed = VoucherConverter.toSignedVoucher((StoredVoucher)original);
        StoredVoucher stored = VoucherConverter.toStoredVoucher((SignedVoucher)signed);
        Assertions.assertThat((String)stored.status()).isEqualTo("issued");
        Assertions.assertThat((Instant)stored.issuedAt()).isNotNull();
        Assertions.assertThat((Instant)stored.issuedAt()).isBeforeOrEqualTo(Instant.now());
    }
}

