/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

@Deprecated(since="1.1.0", forRemoval=true)
public class InMemoryNostrRelayClient
implements NostrRelayClient {
    private final String url;
    private final boolean requiresAuth;
    private final List<Consumer<NostrEvent>> subscribers = new CopyOnWriteArrayList<Consumer<NostrEvent>>();
    private volatile boolean authEnabled;

    public InMemoryNostrRelayClient(String url, boolean requiresAuth) {
        this.url = Objects.requireNonNull(url, "url");
        this.requiresAuth = requiresAuth;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public void connect() {
    }

    @Override
    public void enableAuth(IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        if (!this.requiresAuth) {
            return;
        }
        Objects.requireNonNull(identityKey, "identityKey");
        Objects.requireNonNull(walletSigningKey, "walletSigningKey");
        this.authEnabled = true;
    }

    @Override
    public void publish(NostrEvent event) {
        for (Consumer<NostrEvent> subscriber : this.subscribers) {
            subscriber.accept(event);
        }
    }

    @Override
    public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        Consumer<NostrEvent> wrapped = event -> {
            if (subscription.filter().test((NostrEvent)event)) {
                consumer.accept((NostrEvent)event);
            }
        };
        this.subscribers.add(wrapped);
        return () -> this.subscribers.remove(wrapped);
    }

    @Override
    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    @Override
    public void close() {
        this.subscribers.clear();
    }
}

