/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.InMemoryNostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClientFactory;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class InMemoryRelayClientFactory
implements NostrRelayClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryRelayClientFactory.class);
    private static final String CLIENT_TYPE_PROPERTY = "wallet.nostr.client.type";
    private static final String CLIENT_TYPE_ENV_VAR = "WALLET_NOSTR_CLIENT_TYPE";
    private static final String NOSTR_JAVA_TYPE = "nostr-java";
    private static final String IN_MEMORY_TYPE = "in-memory";
    private static final String DEFAULT_CLIENT_TYPE = "nostr-java";
    private final NostrJavaRelayClientFactory nostrJavaFactory = new NostrJavaRelayClientFactory();

    @Override
    public NostrRelayClient create(NostrRelayOption option, IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        String clientType = this.getClientType();
        log.debug("Creating relay client for " + option.url() + " with type: " + clientType);
        return switch (clientType.toLowerCase()) {
            case "nostr-java" -> {
                log.debug("Using nostr-java implementation");
                yield this.nostrJavaFactory.create(option, identityKey, walletSigningKey);
            }
            case IN_MEMORY_TYPE -> {
                log.debug("Using in-memory implementation (testing mode)");
                yield new InMemoryNostrRelayClient(option.url(), option.requiresAuth());
            }
            default -> throw new IllegalArgumentException("Invalid client type: " + clientType + ". Supported values: nostr-java, in-memory");
        };
    }

    private String getClientType() {
        String type = System.getProperty(CLIENT_TYPE_PROPERTY);
        if (type == null || type.isBlank()) {
            type = System.getenv(CLIENT_TYPE_ENV_VAR);
        }
        if (type == null || type.isBlank()) {
            type = "nostr-java";
        }
        return type.trim();
    }

    public static String getDefaultClientType() {
        return "nostr-java";
    }

    public boolean isUsingNostrJava() {
        return this.getClientType().equalsIgnoreCase("nostr-java");
    }

    public boolean isUsingInMemory() {
        return this.getClientType().equalsIgnoreCase(IN_MEMORY_TYPE);
    }
}

