/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;

@Deprecated(since="1.1.0", forRemoval=true)
public record NostrEvent(String id, String pubkey, int kind, String content, Instant createdAt, List<List<String>> tags, String sig) {
    private static final ObjectMapper CANONICAL_MAPPER = new ObjectMapper();

    public NostrEvent {
        createdAt = createdAt != null ? createdAt : Instant.now();
        tags = tags != null ? List.copyOf(tags) : List.of();
    }

    public static NostrEvent unsigned(String pubkey, int kind, String content, Instant createdAt, List<List<String>> tags) {
        String id = NostrEvent.generateDeterministicId(pubkey, kind, content, tags, createdAt);
        return new NostrEvent(id, pubkey, kind, content, createdAt, tags, null);
    }

    public static String generateDeterministicId(String pubkey, int kind, String content, List<List<String>> tags, Instant createdAt) {
        Objects.requireNonNull(pubkey, "pubkey");
        Objects.requireNonNull(createdAt, "createdAt");
        ArrayNode root = CANONICAL_MAPPER.createArrayNode();
        root.add(0);
        root.add(pubkey);
        root.add(createdAt.getEpochSecond());
        root.add(kind);
        ArrayNode tagsNode = CANONICAL_MAPPER.createArrayNode();
        if (tags != null) {
            for (List<String> tag : tags) {
                ArrayNode tagNode = CANONICAL_MAPPER.createArrayNode();
                if (tag != null) {
                    for (String value : tag) {
                        tagNode.add(value == null ? "" : value);
                    }
                }
                tagsNode.add((JsonNode)tagNode);
            }
        }
        root.add((JsonNode)tagsNode);
        root.add(content != null ? content : "");
        try {
            byte[] canonical = CANONICAL_MAPPER.writeValueAsBytes((Object)root);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(canonical);
            return HexFormat.of().formatHex(hash);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate deterministic Nostr event id", e);
        }
    }
}

