/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;

public record NostrGatewayConfig(List<NostrRelayOption> relays, List<NostrRelayOption> writeRelays, List<NostrRelayOption> readRelays) {
    public NostrGatewayConfig {
        relays = relays == null ? List.of() : List.copyOf(relays);
        writeRelays = writeRelays == null ? List.of() : List.copyOf(writeRelays);
        readRelays = readRelays == null ? List.of() : List.copyOf(readRelays);
    }

    public NostrGatewayConfig(List<NostrRelayOption> relays) {
        this(relays, null, null);
    }

    public boolean hasSegregatedRelays() {
        return !this.writeRelays.isEmpty() || !this.readRelays.isEmpty();
    }

    public static NostrGatewayConfig load() {
        return NostrGatewayConfig.load(StoragePaths.walletHome());
    }

    public static NostrGatewayConfig load(Path walletHome) {
        Properties props = new Properties();
        Path configPath = walletHome.resolve("config.properties");
        if (Files.exists(configPath, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(configPath.toFile());){
                props.load(in);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load config.properties", e);
            }
        }
        String envRelays = System.getenv("NOSTR_RELAYS");
        String fileRelays = props.getProperty("nostr.relays");
        String relaySource = envRelays != null && !envRelays.isBlank() ? envRelays : fileRelays;
        List<NostrRelayOption> unifiedRelays = relaySource != null ? NostrRelayOption.parseList(relaySource) : Collections.emptyList();
        String envWriteRelays = System.getenv("NOSTR_WRITE_RELAYS");
        String fileWriteRelays = props.getProperty("nostr.write.relays");
        String writeSource = envWriteRelays != null && !envWriteRelays.isBlank() ? envWriteRelays : fileWriteRelays;
        List<NostrRelayOption> writeRelays = writeSource != null ? NostrRelayOption.parseList(writeSource) : Collections.emptyList();
        String envReadRelays = System.getenv("NOSTR_READ_RELAYS");
        String fileReadRelays = props.getProperty("nostr.read.relays");
        String readSource = envReadRelays != null && !envReadRelays.isBlank() ? envReadRelays : fileReadRelays;
        List<NostrRelayOption> readRelays = readSource != null ? NostrRelayOption.parseList(readSource) : Collections.emptyList();
        return new NostrGatewayConfig(unifiedRelays, writeRelays, readRelays);
    }
}

