/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrEventVerifier;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.RelayUnavailableException;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthRepository;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthSnapshot;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicyType;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySet;
import xyz.tcheeric.wallet.core.nostr.relay.RelayTelemetry;
import xyz.tcheeric.wallet.core.nostr.relay.RelayTelemetryCollector;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class NostrGatewayService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NostrGatewayService.class);
    private final Supplier<NostrGatewayConfig> configSupplier;
    private final IdentityKeyService identityKeyService;
    private final WalletKeyManager walletKeyManager;
    private final NostrRelayClientFactory clientFactory;
    private final RelaySelectionPolicy selectionPolicy;
    private final RelayHealthMonitor healthMonitor;
    private final RelayReEvaluator reEvaluator;
    private final RelayHealthRepository healthRepository;
    private final RelayTelemetryCollector telemetryCollector;
    private final NostrEventVerifier eventVerifier;
    private static final int EVICTION_OPERATION_THRESHOLD = 25;
    private static final long MIN_EVICTION_INTERVAL_NANOS = Duration.ofSeconds(15L).toNanos();
    private final AtomicLong operationsSinceLastEvictionCheck = new AtomicLong();
    private final AtomicBoolean evictionCheckRunning = new AtomicBoolean();
    private volatile long lastEvictionCheckNanos = System.nanoTime();
    private volatile Map<String, NostrRelayClient> activeClients = Map.of();
    private volatile RelaySet relaySet;
    private final ConcurrentMap<String, CircuitBreaker> relayCircuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    private final CircuitBreakerConfig circuitBreakerConfig;
    private volatile boolean started;
    private volatile IdentityKey identityKey;
    private volatile WalletSigningKey walletSigningKey;
    private volatile NostrGatewayConfig config = new NostrGatewayConfig(List.of());

    public NostrGatewayService(Supplier<NostrGatewayConfig> configSupplier, IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, NostrRelayClientFactory clientFactory, RelaySelectionPolicy selectionPolicy) {
        this(configSupplier, identityKeyService, walletKeyManager, clientFactory, selectionPolicy, new RelayHealthMonitor(), new RelayReEvaluator(), new RelayHealthRepository(), NostrGatewayService.isTelemetryEnabled());
    }

    public NostrGatewayService(Supplier<NostrGatewayConfig> configSupplier, IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, NostrRelayClientFactory clientFactory) {
        this(configSupplier, identityKeyService, walletKeyManager, clientFactory, RelaySelectionPolicyType.RANDOM.createPolicy());
    }

    public NostrGatewayService(Supplier<NostrGatewayConfig> configSupplier, IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, NostrRelayClientFactory clientFactory, RelaySelectionPolicy selectionPolicy, RelayHealthMonitor healthMonitor, RelayReEvaluator reEvaluator, RelayHealthRepository healthRepository, boolean telemetryEnabled) {
        this.configSupplier = Objects.requireNonNull(configSupplier, "configSupplier");
        this.identityKeyService = Objects.requireNonNull(identityKeyService, "identityKeyService");
        this.walletKeyManager = Objects.requireNonNull(walletKeyManager, "walletKeyManager");
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        this.selectionPolicy = Objects.requireNonNull(selectionPolicy, "selectionPolicy");
        this.healthMonitor = Objects.requireNonNull(healthMonitor, "healthMonitor");
        this.reEvaluator = Objects.requireNonNull(reEvaluator, "reEvaluator");
        this.healthRepository = Objects.requireNonNull(healthRepository, "healthRepository");
        this.telemetryCollector = new RelayTelemetryCollector(healthMonitor, reEvaluator, telemetryEnabled);
        this.eventVerifier = new NostrEventVerifier();
        this.circuitBreakerConfig = NostrGatewayService.buildCircuitBreakerConfigFromSystem();
    }

    private static boolean isTelemetryEnabled() {
        String env = System.getenv("RELAY_TELEMETRY_ENABLED");
        return "true".equalsIgnoreCase(env);
    }

    public static NostrGatewayService createDefault() {
        StoragePaths.ensureDirs();
        Path home = StoragePaths.walletHome();
        SecureKeyStore secureKeyStore = SecureKeyStore.create((Path)home);
        RelaySelectionPolicy policy = RelaySelectionPolicyType.STICKY.createPolicy();
        return new NostrGatewayService(() -> NostrGatewayConfig.load(home), new IdentityKeyService(home), new WalletKeyManager(secureKeyStore), new NostrJavaRelayClientFactory(), policy);
    }

    public static NostrGatewayService createDefaultWithFactory(NostrRelayClientFactory clientFactory) {
        StoragePaths.ensureDirs();
        Path home = StoragePaths.walletHome();
        SecureKeyStore secureKeyStore = SecureKeyStore.create((Path)home);
        RelaySelectionPolicy policy = RelaySelectionPolicyType.STICKY.createPolicy();
        return new NostrGatewayService(() -> NostrGatewayConfig.load(home), new IdentityKeyService(home), new WalletKeyManager(secureKeyStore), clientFactory, policy);
    }

    public synchronized void start() {
        if (this.started) {
            LOGGER.debug("nostr_gateway start_skipped reason=already_started active_relays={}", (Object)this.activeClients.size());
            return;
        }
        this.operationsSinceLastEvictionCheck.set(0L);
        this.lastEvictionCheckNanos = System.nanoTime();
        this.evictionCheckRunning.set(false);
        this.config = this.configSupplier.get();
        this.identityKey = this.identityKeyService.loadOrCreate();
        LOGGER.info("GATEWAY: Loaded identity key, pubkey: {} (length: {})", (Object)this.identityKey.publicKeyHex(), (Object)this.identityKey.publicKeyHex().length());
        this.walletSigningKey = this.walletKeyManager.loadOrCreate(this.identityKey);
        try {
            RelayHealthSnapshot snapshot = this.healthRepository.load();
            if (!snapshot.isEmpty()) {
                this.healthMonitor.restoreMetrics(snapshot.metrics());
                this.reEvaluator.restoreEvictedRelays(snapshot.evictedRelays());
                LOGGER.info("nostr_gateway health_state_restored metrics={} evicted={}", (Object)snapshot.metrics().size(), (Object)snapshot.evictedRelays().size());
            }
        }
        catch (Exception e) {
            LOGGER.warn("nostr_gateway health_state_restore_failed reason={} impact=starting_fresh", (Object)e.getMessage(), (Object)e);
        }
        this.relaySet = this.buildRelaySet(this.config);
        LOGGER.info("nostr_gateway initialization_started relay_count={} segregated={}", (Object)this.relaySet.totalRelayCount(), (Object)this.relaySet.isSegregated());
        LinkedHashMap<String, NostrRelayClient> tmp = new LinkedHashMap<String, NostrRelayClient>();
        for (RelayConnection relayConn : this.relaySet.allRelays()) {
            LOGGER.debug("nostr_gateway relay_connect_attempt url={} status={} outcome=connecting", (Object)relayConn.url(), (Object)relayConn.status());
            this.healthMonitor.registerRelay(relayConn.url());
            try {
                NostrRelayOption option = this.findRelayOption(relayConn.url());
                NostrRelayClient client = this.clientFactory.create(option, this.identityKey, this.walletSigningKey);
                client.connect();
                this.healthMonitor.recordConnectionAttempt(relayConn.url(), true);
                LOGGER.info("nostr_gateway relay_connected url={} auth_required={} outcome=connected", (Object)relayConn.url(), (Object)option.requiresAuth());
                if (option.requiresAuth()) {
                    client.enableAuth(this.identityKey, this.walletSigningKey);
                    LOGGER.debug("nostr_gateway relay_auth_enabled url={} outcome=auth_enabled", (Object)relayConn.url());
                }
                tmp.put(relayConn.url(), client);
            }
            catch (RuntimeException e) {
                this.healthMonitor.recordConnectionAttempt(relayConn.url(), false);
                LOGGER.warn("nostr_gateway relay_connect_failed url={} outcome=skipped error={}", new Object[]{relayConn.url(), e.getMessage(), e});
            }
        }
        if (tmp.isEmpty() && this.relaySet.totalRelayCount() > 0) {
            throw new IllegalStateException("nostr_gateway initialization_failed outcome=no_relays_available total_configured=" + this.relaySet.totalRelayCount());
        }
        if (tmp.isEmpty()) {
            LOGGER.warn("nostr_gateway started_without_relays outcome=degraded_mode impact=nostr_operations_unavailable");
        }
        this.activeClients = Collections.unmodifiableMap(tmp);
        this.relayCircuitBreakers.keySet().retainAll(tmp.keySet());
        this.started = true;
        long authEnabled = tmp.values().stream().filter(NostrRelayClient::isAuthEnabled).count();
        LOGGER.info("nostr_gateway initialization_completed relay_count={} write_relays={} read_relays={} auth_enabled_count={} outcome=ready", new Object[]{tmp.size(), this.relaySet.writeRelays().size(), this.relaySet.readRelays().size(), authEnabled});
    }

    private RelaySet buildRelaySet(NostrGatewayConfig config) {
        if (config.hasSegregatedRelays()) {
            List<NostrRelayOption> writeOptions = !config.writeRelays().isEmpty() ? config.writeRelays() : config.relays();
            List<NostrRelayOption> readOptions = !config.readRelays().isEmpty() ? config.readRelays() : config.relays();
            List<RelayConnection> writeRelays = this.buildRelayConnections(writeOptions, NostrRelayOption::canWrite);
            List<RelayConnection> readRelays = this.buildRelayConnections(readOptions, NostrRelayOption::canRead);
            return new RelaySet(writeRelays, readRelays);
        }
        List<NostrRelayOption> unifiedOptions = config.relays();
        if (unifiedOptions.isEmpty()) {
            LOGGER.warn("nostr_gateway initialized_without_relays outcome=degraded_mode impact=nostr_operations_unavailable");
            return new RelaySet(List.of(), List.of());
        }
        List<RelayConnection> writeRelays = this.buildRelayConnections(unifiedOptions, NostrRelayOption::canWrite);
        List<RelayConnection> readRelays = this.buildRelayConnections(unifiedOptions, NostrRelayOption::canRead);
        return new RelaySet(writeRelays, readRelays);
    }

    private List<RelayConnection> buildRelayConnections(List<NostrRelayOption> options, Predicate<NostrRelayOption> filter) {
        return options.stream().filter(filter).map(option -> RelayConnection.connected(option.url())).collect(Collectors.toList());
    }

    private NostrRelayOption findRelayOption(String url) {
        return Stream.of(this.config.relays(), this.config.writeRelays(), this.config.readRelays()).flatMap(Collection::stream).filter(option -> option.url().equals(url)).findFirst().orElseThrow(() -> new IllegalStateException("No relay option found for URL: " + url));
    }

    public synchronized void reload() {
        LOGGER.info("nostr_gateway reload_requested active_relays={} outcome=reloading", (Object)this.activeClients.size());
        this.closeClients();
        this.started = false;
        this.start();
    }

    public synchronized List<NostrRelayOption> activeRelayOptions() {
        this.ensureStarted();
        return List.copyOf(this.config.relays());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> relayAuthStates() {
        Map<String, NostrRelayClient> clients;
        NostrGatewayService nostrGatewayService = this;
        synchronized (nostrGatewayService) {
            this.ensureStarted();
            clients = this.activeClients;
        }
        LOGGER.debug("nostr_gateway auth_state_inspected relay_count={}", (Object)clients.size());
        return clients.values().stream().collect(Collectors.toUnmodifiableMap(NostrRelayClient::url, NostrRelayClient::isAuthEnabled));
    }

    public void publish(NostrEvent event) {
        this.publish(event, null);
    }

    public void publish(NostrEvent event, Collection<String> relayUrls) {
        Objects.requireNonNull(event, "event");
        List<NostrRelayClient> targets = this.selectClients(relayUrls, RelaySelectionPolicy.OperationType.PUBLISH);
        LOGGER.debug("nostr_gateway publish_started event_id={} relay_count={} relay_selection={} outcome=dispatching", new Object[]{event.id(), targets.size(), relayUrls == null || relayUrls.isEmpty() ? "default" : "custom"});
        ArrayList<String> dispatchedUrls = new ArrayList<String>();
        ArrayList<String> circuitOpen = new ArrayList<String>();
        for (NostrRelayClient client : targets) {
            CircuitBreaker breaker = this.circuitBreakerFor(client);
            Instant start = Instant.now();
            try {
                CircuitBreaker.decorateRunnable((CircuitBreaker)breaker, () -> client.publish(event)).run();
                Duration latency = Duration.between(start, Instant.now());
                this.healthMonitor.recordOperation(client.url(), true, latency);
                this.maybeEvictUnhealthyRelays();
                LOGGER.trace("nostr_gateway relay_publish_succeeded event_id={} url={} latency_ms={}", new Object[]{event.id(), client.url(), latency.toMillis()});
                dispatchedUrls.add(client.url());
            }
            catch (CallNotPermittedException e) {
                this.healthMonitor.recordOperation(client.url(), false, null);
                this.maybeEvictUnhealthyRelays();
                LOGGER.warn("nostr_gateway relay_publish_skipped event_id={} url={} reason=circuit_open circuit_state={} impact=event_skipped", new Object[]{event.id(), client.url(), breaker.getState(), e});
                circuitOpen.add(client.url());
            }
            catch (RuntimeException e) {
                Duration latency = Duration.between(start, Instant.now());
                this.healthMonitor.recordOperation(client.url(), false, latency);
                this.maybeEvictUnhealthyRelays();
                LOGGER.error("nostr_gateway relay_publish_failed event_id={} url={} latency_ms={} reason={} impact=event_not_dispatched", new Object[]{event.id(), client.url(), latency.toMillis(), e.getMessage(), e});
                throw e;
            }
        }
        if (!circuitOpen.isEmpty()) {
            LOGGER.warn("nostr_gateway relay_circuits_open event_id={} skipped_relays={} impact=partial_dispatch", (Object)event.id(), (Object)String.join((CharSequence)",", circuitOpen));
        }
        if (!targets.isEmpty() && dispatchedUrls.isEmpty()) {
            throw new RelayUnavailableException("all-relays");
        }
        LOGGER.info("nostr_gateway publish_completed event_id={} dispatched_relays={} outcome=published", (Object)event.id(), (Object)dispatchedUrls.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictUnhealthyRelays() {
        boolean timeThresholdReached;
        long operations = this.operationsSinceLastEvictionCheck.incrementAndGet();
        long now = System.nanoTime();
        long lastCheck = this.lastEvictionCheckNanos;
        boolean operationThresholdReached = operations >= 25L;
        boolean bl = timeThresholdReached = now - lastCheck >= MIN_EVICTION_INTERVAL_NANOS;
        if (!operationThresholdReached && !timeThresholdReached) {
            return;
        }
        if (!this.evictionCheckRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            this.operationsSinceLastEvictionCheck.getAndSet(0L);
            this.lastEvictionCheckNanos = now;
            this.evictUnhealthyRelays();
        }
        finally {
            this.evictionCheckRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictUnhealthyRelays() {
        Map<String, Double> evictionCandidates = this.healthMonitor.getRelaysForEviction();
        if (evictionCandidates.isEmpty()) {
            return;
        }
        LinkedHashMap<String, NostrRelayClient> removedClients = new LinkedHashMap<String, NostrRelayClient>();
        LinkedHashMap<String, Double> evictedScores = new LinkedHashMap<String, Double>();
        NostrGatewayService nostrGatewayService = this;
        synchronized (nostrGatewayService) {
            if (this.activeClients.isEmpty()) {
                return;
            }
            LinkedHashMap<String, NostrRelayClient> linkedHashMap = new LinkedHashMap<String, NostrRelayClient>(this.activeClients);
            boolean modified = false;
            for (Map.Entry<String, Double> entry : evictionCandidates.entrySet()) {
                NostrRelayClient removed;
                String url = entry.getKey();
                if (this.reEvaluator.isEvicted(url) || (removed = (NostrRelayClient)linkedHashMap.remove(url)) == null) continue;
                removedClients.put(url, removed);
                evictedScores.put(url, entry.getValue());
                this.reEvaluator.evictRelay(url, entry.getValue());
                modified = true;
            }
            if (modified) {
                this.activeClients = Collections.unmodifiableMap(linkedHashMap);
            }
        }
        if (removedClients.isEmpty()) {
            return;
        }
        for (Map.Entry entry : removedClients.entrySet()) {
            try {
                ((NostrRelayClient)entry.getValue()).close();
            }
            catch (Exception e) {
                LOGGER.warn("nostr_gateway relay_close_failed url={} reason={} impact=resource_leak_risk", new Object[]{entry.getKey(), e.getMessage(), e});
            }
        }
        double threshold = this.healthMonitor.getEvictionThreshold();
        for (Map.Entry entry : evictedScores.entrySet()) {
            LOGGER.warn("nostr_gateway relay_evicted url={} score={} threshold={} outcome=removed_from_active", new Object[]{entry.getKey(), entry.getValue(), threshold});
        }
    }

    public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        return this.subscribe(null, subscription, consumer);
    }

    public AutoCloseable subscribe(String name, NostrServerSideFilter serverFilter, Consumer<NostrEvent> consumer) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(serverFilter, "serverFilter");
        return this.subscribe(new NostrSubscription(name, serverFilter), consumer);
    }

    public List<NostrEvent> queryEvents(NostrServerSideFilter filter, Duration timeout) {
        ArrayList<NostrEvent> arrayList;
        block9: {
            Objects.requireNonNull(filter, "filter");
            Objects.requireNonNull(timeout, "timeout");
            this.ensureStarted();
            ConcurrentHashMap events = new ConcurrentHashMap();
            String subscriptionName = "query-" + System.currentTimeMillis();
            LOGGER.debug("nostr_gateway query_started subscription={} timeout_ms={} outcome=subscribing", (Object)subscriptionName, (Object)timeout.toMillis());
            AutoCloseable subscription = this.subscribe(subscriptionName, filter, (NostrEvent event) -> {
                events.putIfAbsent(event.id(), event);
                LOGGER.trace("nostr_gateway query_event_received subscription={} event_id={} total_collected={}", new Object[]{subscriptionName, event.id(), events.size()});
            });
            try {
                Thread.sleep(timeout.toMillis());
                LOGGER.info("nostr_gateway query_completed subscription={} events_collected={} outcome=success", (Object)subscriptionName, (Object)events.size());
                arrayList = new ArrayList<NostrEvent>(events.values());
                if (subscription == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (subscription != null) {
                        try {
                            subscription.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("nostr_gateway query_interrupted subscription={} events_collected={} outcome=interrupted", (Object)subscriptionName, (Object)events.size());
                    throw new RuntimeException("Query interrupted: " + e.getMessage(), e);
                }
                catch (Exception e) {
                    LOGGER.error("nostr_gateway query_failed subscription={} reason={} outcome=failed", new Object[]{subscriptionName, e.getMessage(), e});
                    throw new RuntimeException("Query failed: " + e.getMessage(), e);
                }
            }
            subscription.close();
        }
        return arrayList;
    }

    public AutoCloseable subscribeTextNotesByAuthorsSince(String name, Collection<String> authorHex, Instant since, int limit, Consumer<NostrEvent> consumer) {
        NostrServerSideFilter serverFilter = NostrFilterBuilder.textNotesByAuthorsSince(authorHex, since, limit);
        return this.subscribe(name, serverFilter, consumer);
    }

    public AutoCloseable subscribe(Collection<String> relayUrls, String name, NostrServerSideFilter serverFilter, Consumer<NostrEvent> consumer) {
        Objects.requireNonNull(relayUrls, "relayUrls");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(serverFilter, "serverFilter");
        return this.subscribe(relayUrls, new NostrSubscription(name, serverFilter), consumer);
    }

    public AutoCloseable subscribe(Collection<String> relayUrls, NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        Objects.requireNonNull(subscription, "subscription");
        Objects.requireNonNull(consumer, "consumer");
        List<NostrRelayClient> targets = this.selectClients(relayUrls, RelaySelectionPolicy.OperationType.SUBSCRIBE);
        LOGGER.debug("nostr_gateway subscribe_started subscription_name={} relay_count={} relay_selection={} outcome=subscribing", new Object[]{subscription.name(), targets.size(), relayUrls == null || relayUrls.isEmpty() ? "default" : "custom"});
        Consumer<NostrEvent> verifiedConsumer = this.wrapWithSignatureVerification(consumer, subscription.name());
        ArrayList<AutoCloseable> handles = new ArrayList<AutoCloseable>();
        for (NostrRelayClient client : targets) {
            try {
                handles.add(client.subscribe(subscription, verifiedConsumer));
                LOGGER.trace("nostr_gateway relay_subscription_established subscription_name={} url={}", (Object)subscription.name(), (Object)client.url());
            }
            catch (RuntimeException e) {
                LOGGER.error("nostr_gateway relay_subscription_failed subscription_name={} url={} reason={} impact=subscription_incomplete", new Object[]{subscription.name(), client.url(), e.getMessage(), e});
                handles.forEach(handle -> {
                    try {
                        handle.close();
                    }
                    catch (Exception e2) {
                        LOGGER.warn("nostr_gateway relay_subscription_cleanup_failed subscription_name={} reason={} impact=resource_leak_risk", new Object[]{subscription.name(), e2.getMessage(), e2});
                    }
                });
                throw e;
            }
        }
        return () -> {
            for (AutoCloseable handle : handles) {
                try {
                    handle.close();
                }
                catch (Exception e) {
                    LOGGER.warn("nostr_gateway relay_subscription_cleanup_failed subscription_name={} reason={} impact=resource_leak_risk", new Object[]{subscription.name(), e.getMessage(), e});
                }
            }
        };
    }

    public IdentityKey identityKey() {
        this.ensureStarted();
        return this.identityKey;
    }

    public WalletSigningKey walletSigningKey() {
        this.ensureStarted();
        return this.walletSigningKey;
    }

    public Map<String, Double> getRelayHealthSummary() {
        this.ensureStarted();
        return this.healthMonitor.getHealthSummary();
    }

    public RelayHealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    public RelayReEvaluator getReEvaluator() {
        return this.reEvaluator;
    }

    public RelayTelemetry getRelayTelemetry() {
        return this.telemetryCollector.collect();
    }

    public void logRelayTelemetry() {
        this.telemetryCollector.collectAndLog();
    }

    public int performRelayReEvaluation() {
        this.ensureStarted();
        return this.reEvaluator.performReEvaluation(this::attemptRelayRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptRelayRecovery(String relayUrl) {
        block7: {
            LOGGER.info("nostr_gateway relay_recovery_attempt url={}", (Object)relayUrl);
            try {
                NostrRelayOption option = this.findRelayOption(relayUrl);
                NostrRelayClient client = this.clientFactory.create(option, this.identityKey, this.walletSigningKey);
                client.connect();
                if (option.requiresAuth()) {
                    client.enableAuth(this.identityKey, this.walletSigningKey);
                    LOGGER.debug("nostr_gateway relay_auth_enabled url={} outcome=auth_enabled", (Object)relayUrl);
                }
                this.healthMonitor.recordConnectionAttempt(relayUrl, true);
                Double score = this.healthMonitor.calculateScore(relayUrl);
                if (score != null && score >= this.healthMonitor.getEvictionThreshold()) {
                    NostrGatewayService nostrGatewayService = this;
                    synchronized (nostrGatewayService) {
                        LinkedHashMap<String, NostrRelayClient> mutableClients = new LinkedHashMap<String, NostrRelayClient>(this.activeClients);
                        mutableClients.put(relayUrl, client);
                        this.activeClients = Collections.unmodifiableMap(mutableClients);
                    }
                    this.reEvaluator.promoteRelay(relayUrl);
                    LOGGER.info("nostr_gateway relay_recovered url={} score={} outcome=promoted_to_active", (Object)relayUrl, (Object)score);
                    break block7;
                }
                client.close();
                LOGGER.warn("nostr_gateway relay_recovery_failed url={} score={} reason=still_unhealthy outcome=remains_evicted", (Object)relayUrl, (Object)score);
            }
            catch (Exception e) {
                this.healthMonitor.recordConnectionAttempt(relayUrl, false);
                LOGGER.warn("nostr_gateway relay_recovery_failed url={} reason={} outcome=will_retry_later", new Object[]{relayUrl, e.getMessage(), e});
            }
        }
    }

    private List<NostrRelayClient> selectClients(Collection<String> relayUrls, RelaySelectionPolicy.OperationType operationType) {
        this.ensureStarted();
        Map<String, NostrRelayClient> clients = this.activeClients;
        if (relayUrls != null && !relayUrls.isEmpty()) {
            Set normalized = relayUrls.stream().map(url -> url.endsWith("/") ? url.substring(0, url.length() - 1) : url).collect(Collectors.toSet());
            ArrayList<NostrRelayClient> targets = new ArrayList<NostrRelayClient>();
            for (Map.Entry<String, NostrRelayClient> entry : clients.entrySet()) {
                if (!normalized.contains(entry.getKey())) continue;
                targets.add(entry.getValue());
            }
            return targets;
        }
        List<RelayConnection> candidateRelays = this.relaySet.getRelaysFor(operationType);
        List<RelayConnection> availableRelays = candidateRelays.stream().filter(relayConn -> clients.containsKey(relayConn.url())).toList();
        if (availableRelays.isEmpty()) {
            LOGGER.warn("nostr_gateway no_available_relays operation_type={} candidate_count={} outcome=using_all_relays", (Object)operationType, (Object)candidateRelays.size());
            return List.copyOf(clients.values());
        }
        int requestedCount = availableRelays.size();
        RelaySelectionPolicy.SelectionContext context = switch (operationType) {
            default -> throw new MatchException(null, null);
            case RelaySelectionPolicy.OperationType.PUBLISH -> RelaySelectionPolicy.SelectionContext.forPublish();
            case RelaySelectionPolicy.OperationType.SUBSCRIBE -> RelaySelectionPolicy.SelectionContext.forSubscribe();
            case RelaySelectionPolicy.OperationType.QUERY -> RelaySelectionPolicy.SelectionContext.forQuery();
        };
        List<RelayConnection> selectedRelays = this.selectionPolicy.select(availableRelays, requestedCount, context);
        return selectedRelays.stream().map(relayConn -> (NostrRelayClient)clients.get(relayConn.url())).filter(Objects::nonNull).toList();
    }

    private synchronized void ensureStarted() {
        if (!this.started) {
            LOGGER.debug("nostr_gateway ensure_started_triggered reason=lazy_start outcome=starting");
            this.start();
        }
    }

    private Consumer<NostrEvent> wrapWithSignatureVerification(Consumer<NostrEvent> consumer, String subscriptionName) {
        return event -> {
            if (event.sig() == null || event.sig().isEmpty()) {
                LOGGER.warn("nostr_gateway event_received_without_signature subscription={} event_id={} outcome=accepted_with_warning", (Object)subscriptionName, (Object)event.id());
                consumer.accept((NostrEvent)event);
                return;
            }
            NostrEventVerifier.VerificationResult result = this.eventVerifier.verify((NostrEvent)event, event.sig());
            if (result.isValid()) {
                LOGGER.trace("nostr_gateway event_signature_verified subscription={} event_id={} outcome=accepted", (Object)subscriptionName, (Object)event.id());
                consumer.accept((NostrEvent)event);
            } else {
                LOGGER.error("nostr_gateway event_signature_invalid subscription={} event_id={} reason={} message={} outcome=rejected_security_event", new Object[]{subscriptionName, event.id(), result.getFailureReason(), result.getFailureMessage()});
            }
        };
    }

    @Override
    public synchronized void close() {
        LOGGER.info("nostr_gateway shutdown_started active_relays={} outcome=closing", (Object)this.activeClients.size());
        try {
            this.healthRepository.save(this.healthMonitor.getAllMetrics(), this.reEvaluator.getAllEvictedRelays());
            LOGGER.info("nostr_gateway health_state_persisted");
        }
        catch (Exception e) {
            LOGGER.error("nostr_gateway health_state_persist_failed reason={}", (Object)e.getMessage(), (Object)e);
        }
        this.closeClients();
        this.started = false;
        LOGGER.info("nostr_gateway shutdown_completed outcome=closed");
    }

    private void closeClients() {
        Map<String, NostrRelayClient> clients = this.activeClients;
        this.activeClients = Map.of();
        this.relayCircuitBreakers.clear();
        for (NostrRelayClient client : clients.values()) {
            try {
                LOGGER.debug("nostr_gateway relay_close_attempt url={} outcome=closing", (Object)client.url());
                client.close();
                LOGGER.trace("nostr_gateway relay_close_completed url={}", (Object)client.url());
            }
            catch (Exception e) {
                LOGGER.warn("nostr_gateway relay_close_failed url={} reason={} impact=resource_leak_risk", new Object[]{client.url(), e.getMessage(), e});
            }
        }
    }

    private CircuitBreaker circuitBreakerFor(NostrRelayClient client) {
        return this.relayCircuitBreakers.computeIfAbsent(client.url(), url -> CircuitBreaker.of((String)url, (CircuitBreakerConfig)this.circuitBreakerConfig));
    }

    private static CircuitBreakerConfig buildCircuitBreakerConfigFromSystem() {
        int failureRate = NostrGatewayService.getIntProp("wallet.relay.circuitBreaker.failureRateThreshold", 50);
        String windowTypeStr = NostrGatewayService.getProp("wallet.relay.circuitBreaker.windowType", "COUNT");
        int windowSize = NostrGatewayService.getIntProp("wallet.relay.circuitBreaker.windowSize", 10);
        int minCalls = NostrGatewayService.getIntProp("wallet.relay.circuitBreaker.minimumCalls", 5);
        long openWaitMs = NostrGatewayService.getLongProp("wallet.relay.circuitBreaker.openWaitMs", 30000L);
        int halfOpenPermits = NostrGatewayService.getIntProp("wallet.relay.circuitBreaker.permittedHalfOpen", 2);
        CircuitBreakerConfig.SlidingWindowType windowType = "TIME".equalsIgnoreCase(windowTypeStr) ? CircuitBreakerConfig.SlidingWindowType.TIME_BASED : CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
        return CircuitBreakerConfig.custom().failureRateThreshold((float)failureRate).slidingWindowType(windowType).slidingWindowSize(windowSize).minimumNumberOfCalls(minCalls).waitDurationInOpenState(Duration.ofMillis(openWaitMs)).permittedNumberOfCallsInHalfOpenState(halfOpenPermits).build();
    }

    private static String getProp(String key, String def) {
        String v = System.getProperty(key);
        if (v == null || v.isBlank()) {
            v = System.getenv(key.replace('.', '_').toUpperCase());
        }
        return v == null || v.isBlank() ? def : v;
    }

    private static int getIntProp(String key, int def) {
        try {
            return Integer.parseInt(NostrGatewayService.getProp(key, Integer.toString(def)));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static long getLongProp(String key, long def) {
        try {
            return Long.parseLong(NostrGatewayService.getProp(key, Long.toString(def)));
        }
        catch (Exception ignored) {
            return def;
        }
    }
}

