/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public record NostrRelayOption(String url, boolean requiresAuth, boolean readOnly, boolean writeOnly) {
    public NostrRelayOption {
        if (readOnly && writeOnly) {
            throw new IllegalArgumentException("Relay cannot be both readOnly and writeOnly: " + url);
        }
    }

    public NostrRelayOption(String url, boolean requiresAuth) {
        this(url, requiresAuth, false, false);
    }

    public boolean canWrite() {
        return !this.readOnly;
    }

    public boolean canRead() {
        return !this.writeOnly;
    }

    public static List<NostrRelayOption> parseList(String raw) {
        if (raw == null || raw.isBlank()) {
            return Collections.emptyList();
        }
        String[] entries = raw.split(",");
        ArrayList<NostrRelayOption> options = new ArrayList<NostrRelayOption>();
        for (String entry : entries) {
            String trimmed = entry.trim();
            if (trimmed.isEmpty()) continue;
            options.add(NostrRelayOption.parse(trimmed));
        }
        return options;
    }

    public static NostrRelayOption parse(String raw) {
        String candidate = raw.trim();
        boolean auth = false;
        boolean readOnly = false;
        boolean writeOnly = false;
        int pipeIndex = candidate.lastIndexOf(124);
        while (pipeIndex > candidate.indexOf("://")) {
            String suffix = candidate.substring(pipeIndex + 1).trim().toLowerCase();
            candidate = candidate.substring(0, pipeIndex);
            if (suffix.equals("auth") || suffix.equals("auth=true") || suffix.equals("true")) {
                auth = true;
            } else if (suffix.equals("noauth") || suffix.equals("auth=false") || suffix.equals("false")) {
                auth = false;
            } else if (suffix.equals("read") || suffix.equals("readonly") || suffix.equals("read-only")) {
                readOnly = true;
            } else if (suffix.equals("write") || suffix.equals("writeonly") || suffix.equals("write-only")) {
                writeOnly = true;
            }
            pipeIndex = candidate.lastIndexOf(124);
        }
        if (candidate.endsWith("!auth")) {
            candidate = candidate.substring(0, candidate.length() - 5);
            auth = true;
        } else if (candidate.endsWith("!noauth")) {
            candidate = candidate.substring(0, candidate.length() - 7);
            auth = false;
        } else if (candidate.endsWith("!read")) {
            candidate = candidate.substring(0, candidate.length() - 5);
            readOnly = true;
        } else if (candidate.endsWith("!write")) {
            candidate = candidate.substring(0, candidate.length() - 6);
            writeOnly = true;
        }
        URI uri = URI.create(candidate);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("Relay URL must use ws:// or wss:// scheme: " + raw);
        }
        if (uri.getHost() == null || uri.getHost().isBlank()) {
            throw new IllegalArgumentException("Relay URL must include a host: " + raw);
        }
        boolean queryAuth = false;
        String query = uri.getQuery();
        if (query != null) {
            for (String part : query.split("&")) {
                String[] kv = part.split("=");
                if (kv.length != 2) continue;
                String key = kv[0].toLowerCase();
                String value = kv[1].toLowerCase();
                if (key.equals("auth")) {
                    queryAuth = value.equals("true") || value.equals("1");
                    continue;
                }
                if (!key.equals("access")) continue;
                if (value.equals("read") || value.equals("readonly")) {
                    readOnly = true;
                    continue;
                }
                if (!value.equals("write") && !value.equals("writeonly")) continue;
                writeOnly = true;
            }
        }
        boolean requiresAuth = auth || queryAuth;
        return new NostrRelayOption(NostrRelayOption.stripQuery(uri), requiresAuth, readOnly, writeOnly);
    }

    private static String stripQuery(URI uri) {
        URI normalized = URI.create(uri.getScheme() + "://" + uri.getAuthority() + (uri.getPath() != null ? uri.getPath() : ""));
        return normalized.toString();
    }
}

