/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nostr.base.ElementAttribute;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;

public class NostrEventAdapter {
    private static final Field GENERIC_TAG_CODE_FIELD;

    private NostrEventAdapter() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static GenericEvent toNostrJavaEvent(NostrEvent walletEvent) {
        if (walletEvent == null) {
            return null;
        }
        GenericEvent event = new GenericEvent();
        if (walletEvent.id() != null) {
            event.setId(walletEvent.id());
        }
        event.setPubKey(new PublicKey(walletEvent.pubkey()));
        event.setKind(Integer.valueOf(walletEvent.kind()));
        event.setContent(walletEvent.content());
        event.setCreatedAt(Long.valueOf(walletEvent.createdAt().getEpochSecond()));
        event.setTags(NostrEventAdapter.convertTagsToNostrJava(walletEvent.tags()));
        if (walletEvent.sig() != null) {
            event.setSignature(Signature.fromString((String)walletEvent.sig()));
        }
        return event;
    }

    public static NostrEvent toWalletEvent(GenericEvent nostrEvent) {
        if (nostrEvent == null) {
            return null;
        }
        String id = nostrEvent.getId();
        String pubkey = nostrEvent.getPubKey().toString();
        int kind = nostrEvent.getKind();
        String content = nostrEvent.getContent();
        Instant createdAt = Instant.ofEpochSecond(nostrEvent.getCreatedAt());
        List<List<String>> tags = NostrEventAdapter.convertTagsToWallet(nostrEvent.getTags());
        String sig = nostrEvent.getSignature() != null ? nostrEvent.getSignature().toString() : null;
        return new NostrEvent(id, pubkey, kind, content, createdAt, tags, sig);
    }

    private static List<BaseTag> convertTagsToNostrJava(List<List<String>> walletTags) {
        if (walletTags == null || walletTags.isEmpty()) {
            return new ArrayList<BaseTag>();
        }
        ArrayList<BaseTag> result = new ArrayList<BaseTag>(walletTags.size());
        for (List<String> tagElements : walletTags) {
            if (tagElements == null || tagElements.isEmpty()) {
                result.add((BaseTag)new GenericTag(""));
                continue;
            }
            String code = NostrEventAdapter.normalizeElement(tagElements.get(0));
            ArrayList<ElementAttribute> attributes = new ArrayList<ElementAttribute>(Math.max(0, tagElements.size() - 1));
            for (int i = 1; i < tagElements.size(); ++i) {
                attributes.add(new ElementAttribute("attr" + (i - 1), (Object)NostrEventAdapter.normalizeElement(tagElements.get(i))));
            }
            result.add((BaseTag)new GenericTag(code, attributes));
        }
        return result;
    }

    private static List<List<String>> convertTagsToWallet(List<BaseTag> nostrTags) {
        if (nostrTags == null || nostrTags.isEmpty()) {
            return List.of();
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(nostrTags.size());
        for (BaseTag tag : nostrTags) {
            if (tag == null) {
                result.add(List.of());
                continue;
            }
            ArrayList<String> elements = new ArrayList<String>();
            if (tag instanceof GenericTag) {
                GenericTag genericTag = (GenericTag)tag;
                elements.add(NostrEventAdapter.extractGenericTagCode(genericTag));
                List attributes = genericTag.getAttributes();
                if (attributes != null) {
                    for (ElementAttribute attribute : attributes) {
                        Object attrValue = attribute != null ? attribute.value() : null;
                        elements.add(attrValue != null ? attrValue.toString() : "");
                    }
                }
            } else {
                elements.add(Optional.ofNullable(tag.getCode()).orElse(""));
                List supportedFields = tag.getSupportedFields();
                if (supportedFields != null && !supportedFields.isEmpty()) {
                    for (Field field : supportedFields) {
                        Optional value = tag.getFieldValue(field);
                        elements.add(value.orElse(""));
                    }
                }
            }
            result.add(elements);
        }
        return result;
    }

    private static String normalizeElement(String value) {
        return value != null ? value : "";
    }

    private static String extractGenericTagCode(GenericTag genericTag) {
        try {
            Object raw = GENERIC_TAG_CODE_FIELD.get(genericTag);
            return raw != null ? raw.toString() : "";
        }
        catch (IllegalAccessException ignored) {
            return "";
        }
    }

    static {
        try {
            GENERIC_TAG_CODE_FIELD = GenericTag.class.getDeclaredField("code");
            GENERIC_TAG_CODE_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Missing GenericTag.code field", e);
        }
    }
}

