/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.dm;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto;
import xyz.tcheeric.wallet.core.nostr.dm.DmMessage;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class DmServiceNip04
implements DmService {
    private static final X9ECParameters CURVE_PARAMS = SECNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters DOMAIN = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private static final HexFormat HEX = HexFormat.of();
    private final IdentityKeyService identityKeyService;
    private final WalletKeyManager walletKeyManager;
    private final NostrDmGateway gateway;
    private final DmCrypto crypto;
    private final List<DmMessage> inbox = new CopyOnWriteArrayList<DmMessage>();
    private volatile AutoCloseable subscriptionHandle;
    private volatile String selfPubkeyHex;
    private volatile BigInteger selfPriv;

    public DmServiceNip04(IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, NostrDmGateway gateway, DmCrypto crypto) {
        this.identityKeyService = Objects.requireNonNull(identityKeyService, "identityKeyService");
        this.walletKeyManager = Objects.requireNonNull(walletKeyManager, "walletKeyManager");
        this.gateway = Objects.requireNonNull(gateway, "gateway");
        this.crypto = Objects.requireNonNull(crypto, "crypto");
    }

    @Override
    public DmSendResult send(DmSendRequest request) {
        Objects.requireNonNull(request, "request");
        IdentityKey identityKey = this.identityKeyService.loadOrCreate();
        WalletSigningKey signingKey = this.walletKeyManager.loadOrCreate(identityKey);
        BigInteger senderPriv = this.ensureSelfKey(signingKey);
        BigInteger senderPubX = DOMAIN.getG().multiply(senderPriv).normalize().getAffineXCoord().toBigInteger();
        String senderPubkeyHex = DmServiceNip04.toFixedHex(senderPubX, 32);
        String senderPrivHex = DmServiceNip04.toFixedHex(senderPriv, 32);
        String payload = this.crypto.encrypt(senderPrivHex, request.recipientPubkeyHex(), request.content());
        ArrayList<List<String>> tags = new ArrayList<List<String>>();
        tags.add(List.of("p", request.recipientPubkeyHex()));
        if (request.tags() != null && !request.tags().isEmpty()) {
            tags.addAll(request.tags());
        }
        Instant createdAt = request.createdAt() != null ? request.createdAt() : Instant.now();
        NostrEvent event = NostrEvent.unsigned(senderPubkeyHex, 4, payload, createdAt, tags);
        this.gateway.publish(event);
        return new DmSendResult(event.id(), List.of());
    }

    @Override
    public List<DmMessage> list(DmService.DmQuery query) {
        Objects.requireNonNull(query, "query");
        this.ensureSubscribed();
        return this.inbox.stream().filter(m -> query.since() == null || !m.createdAt().isBefore(query.since())).filter(m -> query.until() == null || !m.createdAt().isAfter(query.until())).filter(m -> query.authors() == null || query.authors().isEmpty() || query.authors().contains(m.senderPubkeyHex())).filter(m -> query.recipients() == null || query.recipients().isEmpty() || query.recipients().contains(m.recipientPubkeyHex())).sorted((a, b) -> b.createdAt().compareTo(a.createdAt())).limit(Math.max(0, query.limit())).toList();
    }

    @Override
    public Optional<DmMessage> get(String eventId) {
        Objects.requireNonNull(eventId, "eventId");
        this.ensureSubscribed();
        return this.inbox.stream().filter(m -> m.eventId().equals(eventId)).findFirst();
    }

    private synchronized BigInteger ensureSelfKey(WalletSigningKey signingKey) {
        if (this.selfPriv != null && this.selfPubkeyHex != null) {
            return this.selfPriv;
        }
        BigInteger d = DmServiceNip04.deriveSecp256k1Key(signingKey, "dm");
        BigInteger x = DOMAIN.getG().multiply(d).normalize().getAffineXCoord().toBigInteger();
        this.selfPriv = d;
        this.selfPubkeyHex = DmServiceNip04.toFixedHex(x, 32);
        return this.selfPriv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSubscribed() {
        if (this.subscriptionHandle != null) {
            return;
        }
        DmServiceNip04 dmServiceNip04 = this;
        synchronized (dmServiceNip04) {
            if (this.subscriptionHandle != null) {
                return;
            }
            IdentityKey id = this.identityKeyService.loadOrCreate();
            WalletSigningKey sk = this.walletKeyManager.loadOrCreate(id);
            this.ensureSelfKey(sk);
            NostrSubscription sub = new NostrSubscription("dm-nip04", e -> e.kind() == 4);
            try {
                this.subscriptionHandle = this.gateway.subscribe(sub, this::onEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onEvent(NostrEvent event) {
        try {
            boolean sentBySelf;
            if (event.kind() != 4) {
                return;
            }
            String recipient = DmServiceNip04.extractFirstTagValue(event.tags(), "p");
            String sender = event.pubkey();
            boolean addressedToSelf = this.selfPubkeyHex != null && this.selfPubkeyHex.equalsIgnoreCase(recipient);
            boolean bl = sentBySelf = this.selfPubkeyHex != null && this.selfPubkeyHex.equalsIgnoreCase(sender);
            if (!addressedToSelf && !sentBySelf) {
                return;
            }
            byte[] otherPubX = HEX.parseHex(addressedToSelf ? sender : recipient);
            String selfPrivHex = DmServiceNip04.toFixedHex(this.selfPriv, 32);
            String decrypted = this.crypto.decrypt(selfPrivHex, addressedToSelf ? sender : recipient, event.content());
            if (decrypted == null) {
                return;
            }
            DmMessage msg = new DmMessage(event.id(), sender, recipient, decrypted, event.createdAt(), event.tags());
            this.inbox.add(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BigInteger deriveSecp256k1Key(WalletSigningKey key, String context) {
        try {
            byte[] out;
            BigInteger d;
            byte[] material = DmServiceNip04.concat(key.privateKey(), key.salt(), key.publicKey());
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(material, "HmacSHA256"));
            int counter = 0;
            while ((d = new BigInteger(1, out = mac.doFinal(("cashu:dm:" + context + ":i=" + key.iterations() + ":c=" + counter).getBytes(StandardCharsets.UTF_8))).mod(DOMAIN.getN())).signum() == 0) {
                if (++counter <= 10) continue;
                throw new IllegalStateException("Failed to derive secp256k1 key");
            }
            return d;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to derive secp256k1 DM key", e);
        }
    }

    private static ECPoint liftX(byte[] xBytes) {
        BigInteger x = new BigInteger(1, xBytes);
        ECFieldElement xField = CURVE_PARAMS.getCurve().fromBigInteger(x);
        ECFieldElement alpha = xField.multiply(xField.square()).add(CURVE_PARAMS.getCurve().getB());
        ECFieldElement beta = alpha.sqrt();
        if (beta == null) {
            return null;
        }
        BigInteger y = beta.toBigInteger();
        if (y.testBit(0)) {
            y = ((ECCurve.AbstractFp)CURVE_PARAMS.getCurve()).getQ().subtract(y);
        }
        return CURVE_PARAMS.getCurve().validatePoint(x, y);
    }

    private static byte[] sha256(byte[] in) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            return d.digest(in);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] toFixed(BigInteger v, int len) {
        byte[] b = v.toByteArray();
        if (b.length == len) {
            return b;
        }
        byte[] out = new byte[len];
        int srcPos = Math.max(0, b.length - len);
        int destPos = Math.max(0, len - b.length);
        int copy = Math.min(len, b.length);
        System.arraycopy(b, srcPos, out, destPos, copy);
        return out;
    }

    private static String toFixedHex(BigInteger v, int len) {
        return HEX.formatHex(DmServiceNip04.toFixed(v, len));
    }

    private static byte[] concat(byte[] ... arrs) {
        int total = 0;
        for (byte[] a : arrs) {
            total += a.length;
        }
        byte[] out = new byte[total];
        int pos = 0;
        for (byte[] a : arrs) {
            System.arraycopy(a, 0, out, pos, a.length);
            pos += a.length;
        }
        return out;
    }

    private static String extractFirstTagValue(List<List<String>> tags, String code) {
        if (tags == null) {
            return null;
        }
        for (List<String> t : tags) {
            if (t == null || t.isEmpty() || !code.equals(t.get(0)) || t.size() < 2) continue;
            return t.get(1);
        }
        return null;
    }
}

