/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthScorer;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

public class RelayHealthMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelayHealthMonitor.class);
    private final ConcurrentHashMap<String, RelayMetrics> relayMetrics = new ConcurrentHashMap();
    private final double evictionThreshold;

    public RelayHealthMonitor() {
        this(30.0);
    }

    public RelayHealthMonitor(double evictionThreshold) {
        if (evictionThreshold < 0.0 || evictionThreshold > 100.0) {
            throw new IllegalArgumentException("evictionThreshold must be between 0 and 100: " + evictionThreshold);
        }
        this.evictionThreshold = evictionThreshold;
        LOGGER.info("relay_health_monitor initialized eviction_threshold={}", (Object)evictionThreshold);
    }

    public void registerRelay(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        this.relayMetrics.putIfAbsent(relayUrl, RelayMetrics.initial(relayUrl));
        LOGGER.debug("relay_health_monitor relay_registered url={}", (Object)relayUrl);
    }

    public void recordConnectionAttempt(String relayUrl, boolean success) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        this.relayMetrics.compute(relayUrl, (url, current) -> {
            if (current == null) {
                current = RelayMetrics.initial(url);
            }
            RelayMetrics updated = current.withConnectionAttempt(success);
            LOGGER.trace("relay_health_monitor connection_recorded url={} success={} attempts={} successes={}", new Object[]{relayUrl, success, updated.connectionAttempts(), updated.successfulConnections()});
            return updated;
        });
    }

    public void recordOperation(String relayUrl, boolean success, Duration latency) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        this.relayMetrics.compute(relayUrl, (url, current) -> {
            if (current == null) {
                current = RelayMetrics.initial(url);
            }
            RelayMetrics updated = current.withOperation(success, latency);
            LOGGER.trace("relay_health_monitor operation_recorded url={} success={} latency={} total={} successes={}", new Object[]{relayUrl, success, latency, updated.totalOperations(), updated.successfulOperations()});
            return updated;
        });
    }

    public RelayMetrics getMetrics(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        return this.relayMetrics.get(relayUrl);
    }

    public Double calculateScore(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        RelayMetrics metrics = this.relayMetrics.get(relayUrl);
        if (metrics == null) {
            return null;
        }
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        return scorer.calculateScore();
    }

    public RelayStatus determineStatus(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        RelayMetrics metrics = this.relayMetrics.get(relayUrl);
        if (metrics == null) {
            return null;
        }
        RelayHealthScorer scorer = new RelayHealthScorer(metrics);
        return scorer.determineStatus();
    }

    public Map<String, Double> getRelaysForEviction() {
        ConcurrentHashMap<String, Double> evictionCandidates = new ConcurrentHashMap<String, Double>();
        for (Map.Entry<String, RelayMetrics> entry : this.relayMetrics.entrySet()) {
            RelayHealthScorer scorer;
            double score;
            String url = entry.getKey();
            RelayMetrics metrics = entry.getValue();
            if (!metrics.hasSufficientData() || !((score = (scorer = new RelayHealthScorer(metrics)).calculateScore()) < this.evictionThreshold)) continue;
            evictionCandidates.put(url, score);
            LOGGER.debug("relay_health_monitor eviction_candidate url={} score={} threshold={}", new Object[]{url, score, this.evictionThreshold});
        }
        if (!evictionCandidates.isEmpty()) {
            LOGGER.info("relay_health_monitor eviction_candidates_identified count={} threshold={}", (Object)evictionCandidates.size(), (Object)this.evictionThreshold);
        }
        return evictionCandidates;
    }

    public Map<String, Double> getHealthSummary() {
        ConcurrentHashMap<String, Double> summary = new ConcurrentHashMap<String, Double>();
        for (Map.Entry<String, RelayMetrics> entry : this.relayMetrics.entrySet()) {
            String url = entry.getKey();
            RelayMetrics metrics = entry.getValue();
            RelayHealthScorer scorer = new RelayHealthScorer(metrics);
            summary.put(url, scorer.calculateScore());
        }
        return summary;
    }

    public boolean removeRelay(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        RelayMetrics removed = this.relayMetrics.remove(relayUrl);
        if (removed != null) {
            LOGGER.info("relay_health_monitor relay_removed url={}", (Object)relayUrl);
            return true;
        }
        return false;
    }

    public void resetMetrics(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        this.relayMetrics.put(relayUrl, RelayMetrics.initial(relayUrl));
        LOGGER.debug("relay_health_monitor metrics_reset url={}", (Object)relayUrl);
    }

    public int getRelayCount() {
        return this.relayMetrics.size();
    }

    public double getEvictionThreshold() {
        return this.evictionThreshold;
    }

    public Map<String, RelayMetrics> getAllMetrics() {
        return Map.copyOf(this.relayMetrics);
    }

    public void restoreMetrics(Map<String, RelayMetrics> metricsMap) {
        Objects.requireNonNull(metricsMap, "metricsMap");
        this.relayMetrics.putAll(metricsMap);
        LOGGER.info("relay_health_monitor metrics_restored count={}", (Object)metricsMap.size());
    }
}

