/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.relay.EvictedRelay;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthMonitor;
import xyz.tcheeric.wallet.core.nostr.relay.RelayHealthScorer;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;
import xyz.tcheeric.wallet.core.nostr.relay.RelayReEvaluator;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;
import xyz.tcheeric.wallet.core.nostr.relay.RelayTelemetry;

public class RelayTelemetryCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelayTelemetryCollector.class);
    private final RelayHealthMonitor healthMonitor;
    private final RelayReEvaluator reEvaluator;
    private final boolean enabled;

    public RelayTelemetryCollector(RelayHealthMonitor healthMonitor, RelayReEvaluator reEvaluator) {
        this(healthMonitor, reEvaluator, false);
    }

    public RelayTelemetryCollector(RelayHealthMonitor healthMonitor, RelayReEvaluator reEvaluator, boolean enabled) {
        this.healthMonitor = Objects.requireNonNull(healthMonitor, "healthMonitor");
        this.reEvaluator = Objects.requireNonNull(reEvaluator, "reEvaluator");
        this.enabled = enabled;
        if (enabled) {
            LOGGER.info("relay_telemetry_collector initialized status=enabled");
        } else {
            LOGGER.debug("relay_telemetry_collector initialized status=disabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RelayTelemetry collect() {
        if (!this.enabled) {
            LOGGER.trace("relay_telemetry_collector collection_skipped reason=disabled");
            return RelayTelemetry.empty();
        }
        Map<String, RelayMetrics> allMetrics = this.healthMonitor.getAllMetrics();
        Map<String, EvictedRelay> evictedRelays = this.reEvaluator.getAllEvictedRelays();
        int totalRelays = allMetrics.size();
        int evictedCount = evictedRelays.size();
        int connectedCount = 0;
        int degradedCount = 0;
        int disconnectedCount = 0;
        double totalHealthScore = 0.0;
        double totalLatency = 0.0;
        int latencyCount = 0;
        long totalOperations = 0L;
        long totalSuccesses = 0L;
        for (RelayMetrics metrics : allMetrics.values()) {
            RelayHealthScorer scorer = new RelayHealthScorer(metrics);
            double score = scorer.calculateScore();
            RelayStatus status = scorer.determineStatus();
            totalHealthScore += score;
            switch (status) {
                case CONNECTED: {
                    ++connectedCount;
                    break;
                }
                case DEGRADED: {
                    ++degradedCount;
                    break;
                }
                case DISCONNECTED: {
                    ++disconnectedCount;
                }
            }
            if (metrics.p95Latency() != null) {
                totalLatency += (double)metrics.p95Latency().toMillis();
                ++latencyCount;
            }
            totalOperations += metrics.totalOperations();
            totalSuccesses += metrics.successfulOperations();
        }
        double averageHealthScore = totalRelays > 0 ? totalHealthScore / (double)totalRelays : 0.0;
        Double averageLatencyMs = latencyCount > 0 ? Double.valueOf(totalLatency / (double)latencyCount) : null;
        long totalFailures = totalOperations - totalSuccesses;
        double overallSuccessRate = totalOperations > 0L ? (double)totalSuccesses / (double)totalOperations : 0.0;
        RelayTelemetry telemetry = new RelayTelemetry(totalRelays, connectedCount, degradedCount, disconnectedCount, evictedCount, averageHealthScore, averageLatencyMs, totalOperations, totalFailures, overallSuccessRate, Instant.now());
        LOGGER.debug("relay_telemetry_collector collected {}", (Object)telemetry.toLogString());
        return telemetry;
    }

    public void collectAndLog() {
        if (!this.enabled) {
            return;
        }
        RelayTelemetry telemetry = this.collect();
        LOGGER.info(telemetry.toLogString());
    }
}

