/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;

public class StickyRelayPolicy
implements RelaySelectionPolicy {
    private final Map<String, Integer> stickyRelays = new ConcurrentHashMap<String, Integer>();

    @Override
    public List<RelayConnection> select(Collection<RelayConnection> availableRelays, int requestedCount, RelaySelectionPolicy.SelectionContext context) {
        Objects.requireNonNull(availableRelays, "availableRelays");
        Objects.requireNonNull(context, "context");
        if (availableRelays.isEmpty()) {
            throw new IllegalArgumentException("availableRelays cannot be empty");
        }
        if (requestedCount <= 0) {
            throw new IllegalArgumentException("requestedCount must be > 0, got: " + requestedCount);
        }
        LinkedHashSet<RelayConnection> selected = new LinkedHashSet<RelayConnection>();
        ArrayList<RelayConnection> stickyHealthy = new ArrayList<RelayConnection>();
        ArrayList<RelayConnection> stickyDegraded = new ArrayList<RelayConnection>();
        ArrayList<RelayConnection> newHealthy = new ArrayList<RelayConnection>();
        ArrayList<RelayConnection> newDegraded = new ArrayList<RelayConnection>();
        for (RelayConnection relay2 : availableRelays) {
            if (!relay2.isAvailable()) continue;
            boolean isSticky = this.stickyRelays.containsKey(relay2.url());
            if (relay2.isHealthy()) {
                if (isSticky) {
                    stickyHealthy.add(relay2);
                    continue;
                }
                newHealthy.add(relay2);
                continue;
            }
            if (isSticky) {
                stickyDegraded.add(relay2);
                continue;
            }
            newDegraded.add(relay2);
        }
        this.addUpTo(selected, stickyHealthy, requestedCount);
        if (selected.size() < requestedCount) {
            this.addUpTo(selected, stickyDegraded, requestedCount - selected.size());
        }
        if (selected.size() < requestedCount) {
            this.addUpTo(selected, newHealthy, requestedCount - selected.size());
        }
        if (selected.size() < requestedCount) {
            this.addUpTo(selected, newDegraded, requestedCount - selected.size());
        }
        List<RelayConnection> result = List.copyOf(selected);
        result.forEach(relay -> this.stickyRelays.merge(relay.url(), 1, Integer::sum));
        return result;
    }

    private void addUpTo(Set<RelayConnection> destination, List<RelayConnection> source, int limit) {
        int added = 0;
        for (RelayConnection relay : source) {
            if (added >= limit) break;
            if (!destination.add(relay)) continue;
            ++added;
        }
    }

    public void clearStickyState() {
        this.stickyRelays.clear();
    }

    public int getSelectionCount(String relayUrl) {
        return this.stickyRelays.getOrDefault(relayUrl, 0);
    }
}

