/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.voucher;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.GenericTagQuery;
import nostr.event.filter.Filters;
import nostr.event.filter.GenericTagQueryFilter;
import nostr.event.impl.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.nostr.NostrClientAdapter;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

public class WalletNostrClientAdapter
extends NostrClientAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WalletNostrClientAdapter.class);
    private final NostrGatewayService nostrGateway;

    public WalletNostrClientAdapter(@NonNull NostrGatewayService nostrGateway, @NonNull List<String> relayUrls, long timeoutMs, int maxRetries) {
        super(relayUrls, timeoutMs, maxRetries);
        if (nostrGateway == null) {
            throw new NullPointerException("nostrGateway is marked non-null but is null");
        }
        if (relayUrls == null) {
            throw new NullPointerException("relayUrls is marked non-null but is null");
        }
        this.nostrGateway = nostrGateway;
        log.info("WalletNostrClientAdapter initialized: relays={}, timeout={}ms", (Object)relayUrls.size(), (Object)timeoutMs);
    }

    public WalletNostrClientAdapter(@NonNull NostrGatewayService nostrGateway) {
        this(nostrGateway, Collections.emptyList(), 5000L, 3);
        if (nostrGateway == null) {
            throw new NullPointerException("nostrGateway is marked non-null but is null");
        }
    }

    public void connect() {
        log.debug("Connect called - wallet NostrGatewayService manages its own connections");
    }

    public void disconnect() {
        log.debug("Disconnect called - wallet NostrGatewayService manages its own connections");
    }

    public void sendEvent(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("Publishing event to wallet's NostrGatewayService: kind={}, id={}", (Object)event.getKind(), (Object)event.getId());
        try {
            NostrEvent walletEvent = this.convertToWalletEvent(event);
            this.nostrGateway.publish(walletEvent);
            log.debug("Event published successfully: id={}", (Object)event.getId());
        }
        catch (Exception e) {
            log.error("Failed to publish event: kind={}, id={}, error={}", new Object[]{event.getKind(), event.getId(), e.getMessage(), e});
            throw new RuntimeException("Failed to publish event: " + e.getMessage(), e);
        }
    }

    public List<GenericEvent> queryEvents(@NonNull GenericTagQuery tagQuery, int timeoutMs) {
        if (tagQuery == null) {
            throw new NullPointerException("tagQuery is marked non-null but is null");
        }
        log.debug("queryEvents called: tagQuery={}, timeoutMs={}", (Object)tagQuery, (Object)timeoutMs);
        try {
            GenericTagQueryFilter filter = new GenericTagQueryFilter(tagQuery);
            Filters filters = new Filters(List.of(filter));
            NostrServerSideFilter serverFilter = new NostrServerSideFilter(List.of(filters));
            List<NostrEvent> walletEvents = this.nostrGateway.queryEvents(serverFilter, Duration.ofMillis(timeoutMs));
            List<GenericEvent> genericEvents = walletEvents.stream().map(NostrEventAdapter::toNostrJavaEvent).collect(Collectors.toList());
            log.debug("queryEvents completed: found {} events", (Object)genericEvents.size());
            return genericEvents;
        }
        catch (Exception e) {
            log.error("queryEvents failed: tagQuery={}, error={}", new Object[]{tagQuery, e.getMessage(), e});
            throw new RuntimeException("Failed to query events: " + e.getMessage(), e);
        }
    }

    private NostrEvent convertToWalletEvent(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Event conversion not yet implemented. Need to map GenericEvent -> NostrEvent with proper tag conversion.");
    }
}

