/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;
import xyz.tcheeric.wallet.core.observability.spi.MetricsExtension;

public class NostrMetricsExtension
implements MetricsExtension {
    public void registerMetrics(MeterRegistry registry) {
        Counter.builder((String)"nostr.events.sent.total").description("Total events sent to Nostr relays").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.events.sent.success").description("Successfully published events").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.events.sent.failure").description("Failed event publishes").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.events.received.total").description("Total events received from Nostr relays").tag("application", "cashu-wallet").register(registry);
        AtomicLong activeConnections = new AtomicLong(0L);
        Gauge.builder((String)"nostr.relay.connections", (Object)activeConnections, AtomicLong::get).description("Current number of active relay connections").tag("application", "cashu-wallet").register(registry);
        Timer.builder((String)"nostr.relay.connect.duration").description("Duration of relay connection operations").tag("application", "cashu-wallet").register(registry);
        Timer.builder((String)"nostr.relay.publish.duration").description("Duration of event publish operations").tag("application", "cashu-wallet").register(registry);
        AtomicLong activeSubscriptions = new AtomicLong(0L);
        Gauge.builder((String)"nostr.subscription.active", (Object)activeSubscriptions, AtomicLong::get).description("Number of active subscriptions across all relays").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.subscription.events").description("Events received per subscription").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.dm.sent.total").description("Direct messages sent (NIP-04/NIP-44)").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"nostr.dm.received.total").description("Direct messages received (NIP-04/NIP-44)").tag("application", "cashu-wallet").register(registry);
        AtomicLong circuitBreakerOpen = new AtomicLong(0L);
        Gauge.builder((String)"nostr.relay.circuit_breaker.open", (Object)circuitBreakerOpen, AtomicLong::get).description("Number of relays with open circuit breakers").tag("application", "cashu-wallet").register(registry);
    }

    public String getName() {
        return "nostr";
    }

    public int getPriority() {
        return 110;
    }
}

