/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Supplier;
import xyz.tcheeric.wallet.core.observability.WalletMetrics;

public class MetricsHelper {
    private final WalletMetrics metrics;

    public MetricsHelper(WalletMetrics metrics) {
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Timer timer, Supplier<T> operation) {
        if (!this.metrics.isEnabled()) {
            return operation.get();
        }
        Timer.Sample sample = Timer.start((MeterRegistry)this.metrics.getRegistry());
        try {
            T t = operation.get();
            return t;
        }
        finally {
            sample.stop(timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Timer timer, Runnable operation) {
        if (!this.metrics.isEnabled()) {
            operation.run();
            return;
        }
        Timer.Sample sample = Timer.start((MeterRegistry)this.metrics.getRegistry());
        try {
            operation.run();
        }
        finally {
            sample.stop(timer);
        }
    }

    public <T> T timePayment(String mintUrl, Supplier<T> operation) {
        if (!this.metrics.isEnabled()) {
            return operation.get();
        }
        this.metrics.recordPaymentAttempt(mintUrl);
        Timer.Sample sample = Timer.start((MeterRegistry)this.metrics.getRegistry());
        try {
            T result = operation.get();
            this.metrics.recordPaymentSuccess(mintUrl);
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.metrics.recordPaymentFailure(mintUrl, e.getClass().getSimpleName());
            throw e;
        }
        finally {
            sample.stop(this.metrics.getPaymentTimer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T timeProofImport(int proofCount, Supplier<T> operation) {
        if (!this.metrics.isEnabled()) {
            return operation.get();
        }
        Timer.Sample sample = Timer.start((MeterRegistry)this.metrics.getRegistry());
        try {
            T result = operation.get();
            this.metrics.recordProofImported(proofCount);
            T t = result;
            return t;
        }
        finally {
            sample.stop(this.metrics.getProofImportTimer());
        }
    }

    public <T> T timeRelayPublish(String relayUrl, Supplier<T> operation) {
        if (!this.metrics.isEnabled()) {
            return operation.get();
        }
        this.metrics.recordRelayPublishAttempt(relayUrl);
        Timer.Sample sample = Timer.start((MeterRegistry)this.metrics.getRegistry());
        try {
            T result = operation.get();
            this.metrics.recordRelayPublishSuccess(relayUrl);
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.metrics.recordRelayPublishFailure(relayUrl, e.getClass().getSimpleName());
            throw e;
        }
        finally {
            sample.stop(this.metrics.getRelayPublishTimer());
        }
    }
}

