/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Supplier;

public class SpanHelper {
    public static final AttributeKey<String> WALLET_OPERATION = AttributeKey.stringKey((String)"wallet.operation");
    public static final AttributeKey<String> WALLET_MINT_URL = AttributeKey.stringKey((String)"wallet.mint.url");
    public static final AttributeKey<Long> WALLET_AMOUNT = AttributeKey.longKey((String)"wallet.amount");
    public static final AttributeKey<String> WALLET_UNIT = AttributeKey.stringKey((String)"wallet.unit");
    public static final AttributeKey<String> WALLET_QUOTE_ID = AttributeKey.stringKey((String)"wallet.quote.id");
    public static final AttributeKey<Long> WALLET_PROOF_COUNT = AttributeKey.longKey((String)"wallet.proof.count");
    public static final AttributeKey<String> WALLET_TOKEN_MEMO = AttributeKey.stringKey((String)"wallet.token.memo");
    public static final AttributeKey<String> NOSTR_RELAY_URL = AttributeKey.stringKey((String)"nostr.relay.url");
    public static final AttributeKey<String> NOSTR_EVENT_ID = AttributeKey.stringKey((String)"nostr.event.id");
    public static final AttributeKey<String> NOSTR_EVENT_KIND = AttributeKey.stringKey((String)"nostr.event.kind");
    private final Tracer tracer;

    public SpanHelper(Tracer tracer) {
        this.tracer = tracer;
    }

    public Span createSpan(String operationName, SpanKind spanKind) {
        return this.tracer.spanBuilder(operationName).setSpanKind(spanKind).startSpan();
    }

    public Span createSpanWithAttributes(String operationName, SpanKind spanKind, Attributes attributes) {
        return this.tracer.spanBuilder(operationName).setSpanKind(spanKind).setAllAttributes(attributes).startSpan();
    }

    public <T> T executeInSpan(String spanName, SpanKind spanKind, Supplier<T> operation) {
        Span span = this.createSpan(spanName, spanKind);
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    T result = operation.get();
                    span.setStatus(StatusCode.OK);
                    t = result;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        SpanHelper.recordException(span, e);
                        throw e;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public void executeInSpan(String spanName, SpanKind spanKind, Runnable operation) {
        Span span = this.createSpan(spanName, spanKind);
        try (Scope scope = span.makeCurrent();){
            operation.run();
            span.setStatus(StatusCode.OK);
        }
        catch (Exception e) {
            SpanHelper.recordException(span, e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public <T> T executeInSpanWithAttributes(String spanName, SpanKind spanKind, Attributes attributes, Supplier<T> operation) {
        Span span = this.createSpanWithAttributes(spanName, spanKind, attributes);
        try {
            T t;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    T result = operation.get();
                    span.setStatus(StatusCode.OK);
                    t = result;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        SpanHelper.recordException(span, e);
                        throw e;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public static void recordException(Span span, Throwable exception) {
        span.recordException(exception, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_TYPE, (Object)exception.getClass().getName(), (AttributeKey)SemanticAttributes.EXCEPTION_MESSAGE, (Object)(exception.getMessage() != null ? exception.getMessage() : "")));
        span.setStatus(StatusCode.ERROR, exception.getMessage());
    }

    public static void addWalletAttributes(Span span, String operation, String mintUrl, Long amount, String unit) {
        if (operation != null) {
            span.setAttribute(WALLET_OPERATION, (Object)operation);
        }
        if (mintUrl != null) {
            span.setAttribute(WALLET_MINT_URL, (Object)mintUrl);
        }
        if (amount != null) {
            span.setAttribute(WALLET_AMOUNT, (Object)amount);
        }
        if (unit != null) {
            span.setAttribute(WALLET_UNIT, (Object)unit);
        }
    }

    public static void addNostrAttributes(Span span, String relayUrl, String eventId) {
        if (relayUrl != null) {
            span.setAttribute(NOSTR_RELAY_URL, (Object)relayUrl);
        }
        if (eventId != null) {
            span.setAttribute(NOSTR_EVENT_ID, (Object)eventId);
        }
    }

    public static Span getCurrentSpan() {
        return Span.current();
    }

    public static Context getCurrentContext() {
        return Context.current();
    }
}

