/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.storage.file;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.Balance;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;
import xyz.tcheeric.wallet.storage.file.BalanceFileRepository;
import xyz.tcheeric.wallet.storage.file.ConfigFileRepository;

public class FileWalletService
implements BalanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWalletService.class);
    private WalletConfig config;
    private final MintApi mintApi;
    private final ConfigFileRepository configRepository = new ConfigFileRepository();
    private final BalanceFileRepository balanceRepository = new BalanceFileRepository();

    public FileWalletService() {
        this((MintApi)new CashuWalletMintApi(RestTemplateFactory.create()));
    }

    public FileWalletService(MintApi mintApi) {
        this.mintApi = mintApi;
    }

    public void init(WalletConfig config) {
        this.config = config;
        StoragePaths.ensureDirs();
        log.info("Initializing wallet with mint {} and default unit {}", (Object)config.defaultMintUrl(), (Object)config.defaultUnit());
        List<String> units = this.validateMint(config.defaultMintUrl());
        this.configRepository.save(config);
        this.balanceRepository.createFileIfMissing(config.defaultUnit(), units);
    }

    public Balance balance() {
        Map<String, Long> totals = this.balanceRepository.loadTotals();
        this.applyDefaults(totals);
        log.info("Loaded balances {}", totals);
        return new Balance(totals);
    }

    private void applyDefaults(Map<String, Long> totals) {
        if (!totals.isEmpty()) {
            return;
        }
        String unit = this.config != null && this.config.defaultUnit() != null ? this.config.defaultUnit() : "sat";
        totals.put(unit, 0L);
    }

    private List<String> validateMint(String mintUrl) {
        try {
            MintApi.MintInfo info = this.mintApi.info(mintUrl);
            log.debug("Mint reported units {}", (Object)info.units());
            return info.units();
        }
        catch (MintApiException e) {
            throw new RuntimeException("Failed to validate mint " + mintUrl, e);
        }
    }
}

